/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class WfmHistoricalAdherenceQuery
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private String timeZone = null;
    private List<String> userIds = new ArrayList<String>();
    private Boolean includeExceptions = null;
    private List<String> teamIds = new ArrayList<String>();

    public WfmHistoricalAdherenceQuery startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Beginning of the date range to query in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public WfmHistoricalAdherenceQuery endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="End of the date range to query in ISO-8601 format. If it is not set, end date will be set to current time")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public WfmHistoricalAdherenceQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The time zone, in olson format, to use in defining days when computing adherence. If it is not set, the business unit time zone will be used. The results will be returned as UTC timestamps regardless of the time zone input.")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public WfmHistoricalAdherenceQuery userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The userIds to report on. If null or not set, adherence will be computed for all the users in management unit or requested teamIds")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public WfmHistoricalAdherenceQuery includeExceptions(Boolean includeExceptions) {
        this.includeExceptions = includeExceptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether user exceptions should be returned as part of the results")
    @JsonProperty(value="includeExceptions")
    public Boolean getIncludeExceptions() {
        return this.includeExceptions;
    }

    public void setIncludeExceptions(Boolean includeExceptions) {
        this.includeExceptions = includeExceptions;
    }

    public WfmHistoricalAdherenceQuery teamIds(List<String> teamIds) {
        this.teamIds = teamIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The teamIds to report on. If null or not set, adherence will be computed for requested users if applicable or otherwise all users in the management unit. Note: If teamIds is also specified, only adherence for users in the requested teams will be returned")
    @JsonProperty(value="teamIds")
    public List<String> getTeamIds() {
        return this.teamIds;
    }

    public void setTeamIds(List<String> teamIds) {
        this.teamIds = teamIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmHistoricalAdherenceQuery wfmHistoricalAdherenceQuery = (WfmHistoricalAdherenceQuery)o;
        return Objects.equals(this.startDate, wfmHistoricalAdherenceQuery.startDate) && Objects.equals(this.endDate, wfmHistoricalAdherenceQuery.endDate) && Objects.equals(this.timeZone, wfmHistoricalAdherenceQuery.timeZone) && Objects.equals(this.userIds, wfmHistoricalAdherenceQuery.userIds) && Objects.equals(this.includeExceptions, wfmHistoricalAdherenceQuery.includeExceptions) && Objects.equals(this.teamIds, wfmHistoricalAdherenceQuery.teamIds);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.timeZone, this.userIds, this.includeExceptions, this.teamIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmHistoricalAdherenceQuery {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    includeExceptions: ").append(this.toIndentedString(this.includeExceptions)).append("\n");
        sb.append("    teamIds: ").append(this.toIndentedString(this.teamIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

