/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="State information for an export job of rows from a datatable")
public class DataTableExportJob
implements Serializable {
    private String id = null;
    private String name = null;
    private AddressableEntityRef owner = null;
    private StatusEnum status = null;
    private Date dateCreated = null;
    private Date dateCompleted = null;
    private String downloadURI = null;
    private ErrorBody errorInformation = null;
    private Integer countRecordsProcessed = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DataTableExportJob name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTableExportJob owner(AddressableEntityRef owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user who started the export job")
    @JsonProperty(value="owner")
    public AddressableEntityRef getOwner() {
        return this.owner;
    }

    public void setOwner(AddressableEntityRef owner) {
        this.owner = owner;
    }

    public DataTableExportJob status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the export job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DataTableExportJob dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the export began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DataTableExportJob dateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the export stopped (either successfully or unsuccessfully). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public DataTableExportJob downloadURI(String downloadURI) {
        this.downloadURI = downloadURI;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the location at which the caller can download the export file, when available")
    @JsonProperty(value="downloadURI")
    public String getDownloadURI() {
        return this.downloadURI;
    }

    public void setDownloadURI(String downloadURI) {
        this.downloadURI = downloadURI;
    }

    public DataTableExportJob errorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error information, or null of the processing is not in an error state")
    @JsonProperty(value="errorInformation")
    public ErrorBody getErrorInformation() {
        return this.errorInformation;
    }

    public void setErrorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
    }

    public DataTableExportJob countRecordsProcessed(Integer countRecordsProcessed) {
        this.countRecordsProcessed = countRecordsProcessed;
        return this;
    }

    @ApiModelProperty(example="null", value="The current count of the number of records processed")
    @JsonProperty(value="countRecordsProcessed")
    public Integer getCountRecordsProcessed() {
        return this.countRecordsProcessed;
    }

    public void setCountRecordsProcessed(Integer countRecordsProcessed) {
        this.countRecordsProcessed = countRecordsProcessed;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTableExportJob dataTableExportJob = (DataTableExportJob)o;
        return Objects.equals(this.id, dataTableExportJob.id) && Objects.equals(this.name, dataTableExportJob.name) && Objects.equals(this.owner, dataTableExportJob.owner) && Objects.equals((Object)this.status, (Object)dataTableExportJob.status) && Objects.equals(this.dateCreated, dataTableExportJob.dateCreated) && Objects.equals(this.dateCompleted, dataTableExportJob.dateCompleted) && Objects.equals(this.downloadURI, dataTableExportJob.downloadURI) && Objects.equals(this.errorInformation, dataTableExportJob.errorInformation) && Objects.equals(this.countRecordsProcessed, dataTableExportJob.countRecordsProcessed) && Objects.equals(this.selfUri, dataTableExportJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.owner, this.status, this.dateCreated, this.dateCompleted, this.downloadURI, this.errorInformation, this.countRecordsProcessed, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataTableExportJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    downloadURI: ").append(this.toIndentedString(this.downloadURI)).append("\n");
        sb.append("    errorInformation: ").append(this.toIndentedString(this.errorInformation)).append("\n");
        sb.append("    countRecordsProcessed: ").append(this.toIndentedString(this.countRecordsProcessed)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        FAILED("Failed"),
        SUCCEEDED("Succeeded");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

