/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Check;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KeyPerformanceIndicatorAssessment
implements Serializable {
    private String kpi = null;
    private AssessmentResultEnum assessmentResult = null;
    private List<Check> checks = new ArrayList<Check>();

    @ApiModelProperty(example="null", value="Name of the key performance indicator assessed.")
    @JsonProperty(value="kpi")
    public String getKpi() {
        return this.kpi;
    }

    @ApiModelProperty(example="null", value="The overall result of the assessment for a key performance indicator.")
    @JsonProperty(value="assessmentResult")
    public AssessmentResultEnum getAssessmentResult() {
        return this.assessmentResult;
    }

    @ApiModelProperty(example="null", value="Set of checks executed as part of an assessment.")
    @JsonProperty(value="checks")
    public List<Check> getChecks() {
        return this.checks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPerformanceIndicatorAssessment keyPerformanceIndicatorAssessment = (KeyPerformanceIndicatorAssessment)o;
        return Objects.equals(this.kpi, keyPerformanceIndicatorAssessment.kpi) && Objects.equals((Object)this.assessmentResult, (Object)keyPerformanceIndicatorAssessment.assessmentResult) && Objects.equals(this.checks, keyPerformanceIndicatorAssessment.checks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kpi, this.assessmentResult, this.checks});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyPerformanceIndicatorAssessment {\n");
        sb.append("    kpi: ").append(this.toIndentedString(this.kpi)).append("\n");
        sb.append("    assessmentResult: ").append(this.toIndentedString((Object)this.assessmentResult)).append("\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AssessmentResultEnumDeserializer.class)
    public static enum AssessmentResultEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        NOTSUPPORTED("NotSupported"),
        HIGH("High"),
        LOW("Low"),
        ERROR("Error");

        private String value;

        private AssessmentResultEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AssessmentResultEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AssessmentResultEnum value : AssessmentResultEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AssessmentResultEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AssessmentResultEnumDeserializer
    extends StdDeserializer<AssessmentResultEnum> {
        public AssessmentResultEnumDeserializer() {
            super(AssessmentResultEnumDeserializer.class);
        }

        public AssessmentResultEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AssessmentResultEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

