/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an unassigned or assigned DID in a DID Pool.")
public class DIDNumber
implements Serializable {
    private String id = null;
    private String name = null;
    private String number = null;
    private Boolean assigned = null;
    private AddressableEntityRef didPool = null;
    private DomainEntityRef owner = null;
    private OwnerTypeEnum ownerType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DIDNumber name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DIDNumber number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of the DID formatted as E164.")
    @JsonProperty(value="number")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public DIDNumber assigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this DID is assigned to an entity.  False otherwise.")
    @JsonProperty(value="assigned")
    public Boolean getAssigned() {
        return this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public DIDNumber didPool(AddressableEntityRef didPool) {
        this.didPool = didPool;
        return this;
    }

    @ApiModelProperty(example="null", value="A Uri reference to the DID Pool this DID is a part of.")
    @JsonProperty(value="didPool")
    public AddressableEntityRef getDidPool() {
        return this.didPool;
    }

    public void setDidPool(AddressableEntityRef didPool) {
        this.didPool = didPool;
    }

    public DIDNumber owner(DomainEntityRef owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="null", value="A Uri reference to the owner of this DID.  The owner's type can be found in ownerType.  If the DID is unassigned, this will be NULL.")
    @JsonProperty(value="owner")
    public DomainEntityRef getOwner() {
        return this.owner;
    }

    public void setOwner(DomainEntityRef owner) {
        this.owner = owner;
    }

    public DIDNumber ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the entity that owns this DID.  If the DID is unassigned, this will be NULL.")
    @JsonProperty(value="ownerType")
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DIDNumber dIDNumber = (DIDNumber)o;
        return Objects.equals(this.id, dIDNumber.id) && Objects.equals(this.name, dIDNumber.name) && Objects.equals(this.number, dIDNumber.number) && Objects.equals(this.assigned, dIDNumber.assigned) && Objects.equals(this.didPool, dIDNumber.didPool) && Objects.equals(this.owner, dIDNumber.owner) && Objects.equals((Object)this.ownerType, (Object)dIDNumber.ownerType) && Objects.equals(this.selfUri, dIDNumber.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.number, this.assigned, this.didPool, this.owner, this.ownerType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DIDNumber {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    didPool: ").append(this.toIndentedString(this.didPool)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OwnerTypeEnumDeserializer.class)
    public static enum OwnerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("USER"),
        PHONE("PHONE"),
        IVR_CONFIG("IVR_CONFIG"),
        GROUP("GROUP");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OwnerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OwnerTypeEnum value : OwnerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OwnerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OwnerTypeEnumDeserializer
    extends StdDeserializer<OwnerTypeEnum> {
        public OwnerTypeEnumDeserializer() {
            super(OwnerTypeEnumDeserializer.class);
        }

        public OwnerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OwnerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

