/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The routing skill assigned to a user.")
public class ScimUserRoutingSkill
implements Serializable {
    private String name = null;
    private Double proficiency = null;

    public ScimUserRoutingSkill name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The case-sensitive name of a routing skill configured in Genesys Cloud.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScimUserRoutingSkill proficiency(Double proficiency) {
        this.proficiency = proficiency;
        return this;
    }

    @ApiModelProperty(example="null", value="A rating from 0.0 to 5.0 that indicates how adept an agent is at a particular skill. When \"Best available skills\" is enabled for a queue in Genesys Cloud, ACD interactions in that queue are routed to agents with higher proficiency ratings.")
    @JsonProperty(value="proficiency")
    public Double getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(Double proficiency) {
        this.proficiency = proficiency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUserRoutingSkill scimUserRoutingSkill = (ScimUserRoutingSkill)o;
        return Objects.equals(this.name, scimUserRoutingSkill.name) && Objects.equals(this.proficiency, scimUserRoutingSkill.proficiency);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.proficiency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimUserRoutingSkill {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proficiency: ").append(this.toIndentedString(this.proficiency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

