/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KeyPerformanceIndicator
implements Serializable {
    private String id = null;
    private String name = null;
    private OptimizationTypeEnum optimizationType = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the Key Performance Indicator.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The optimization type of the Key Performance Indicator.")
    @JsonProperty(value="optimizationType")
    public OptimizationTypeEnum getOptimizationType() {
        return this.optimizationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPerformanceIndicator keyPerformanceIndicator = (KeyPerformanceIndicator)o;
        return Objects.equals(this.id, keyPerformanceIndicator.id) && Objects.equals(this.name, keyPerformanceIndicator.name) && Objects.equals((Object)this.optimizationType, (Object)keyPerformanceIndicator.optimizationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.optimizationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyPerformanceIndicator {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optimizationType: ").append(this.toIndentedString((Object)this.optimizationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OptimizationTypeEnumDeserializer.class)
    public static enum OptimizationTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MAXIMIZATION("Maximization"),
        MINIMIZATION("Minimization");

        private String value;

        private OptimizationTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptimizationTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptimizationTypeEnum value : OptimizationTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptimizationTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OptimizationTypeEnumDeserializer
    extends StdDeserializer<OptimizationTypeEnum> {
        public OptimizationTypeEnumDeserializer() {
            super(OptimizationTypeEnumDeserializer.class);
        }

        public OptimizationTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptimizationTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

