/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ChannelMetadata;
import com.mypurecloud.sdk.v2.model.OpenMessagingFromRecipient;
import com.mypurecloud.sdk.v2.model.OpenMessagingToRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Channel-specific information that describes the message and the message channel/provider.")
public class OpenMessagingChannel
implements Serializable {
    private String id = null;
    private PlatformEnum platform = null;
    private TypeEnum type = null;
    private String messageId = null;
    private OpenMessagingToRecipient to = null;
    private OpenMessagingFromRecipient from = null;
    private Date time = null;
    private ChannelMetadata metadata = null;

    @ApiModelProperty(example="null", value="The Messaging Platform integration ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The provider type.")
    @JsonProperty(value="platform")
    public PlatformEnum getPlatform() {
        return this.platform;
    }

    public OpenMessagingChannel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if this message is part of a private or public conversation.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenMessagingChannel messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique provider ID of the message such as a Facebook message ID.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public OpenMessagingChannel to(OpenMessagingToRecipient to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the recipient the message is sent to.")
    @JsonProperty(value="to")
    public OpenMessagingToRecipient getTo() {
        return this.to;
    }

    public void setTo(OpenMessagingToRecipient to) {
        this.to = to;
    }

    public OpenMessagingChannel from(OpenMessagingFromRecipient from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the recipient the message is received from.")
    @JsonProperty(value="from")
    public OpenMessagingFromRecipient getFrom() {
        return this.from;
    }

    public void setFrom(OpenMessagingFromRecipient from) {
        this.from = from;
    }

    public OpenMessagingChannel time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public OpenMessagingChannel metadata(ChannelMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the channel.")
    @JsonProperty(value="metadata")
    public ChannelMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ChannelMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenMessagingChannel openMessagingChannel = (OpenMessagingChannel)o;
        return Objects.equals(this.id, openMessagingChannel.id) && Objects.equals((Object)this.platform, (Object)openMessagingChannel.platform) && Objects.equals((Object)this.type, (Object)openMessagingChannel.type) && Objects.equals(this.messageId, openMessagingChannel.messageId) && Objects.equals(this.to, openMessagingChannel.to) && Objects.equals(this.from, openMessagingChannel.from) && Objects.equals(this.time, openMessagingChannel.time) && Objects.equals(this.metadata, openMessagingChannel.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.platform, this.type, this.messageId, this.to, this.from, this.time, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenMessagingChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PRIVATE("Private");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=PlatformEnumDeserializer.class)
    public static enum PlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open");

        private String value;

        private PlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PlatformEnum value : PlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PlatformEnumDeserializer
    extends StdDeserializer<PlatformEnum> {
        public PlatformEnumDeserializer() {
            super(PlatformEnumDeserializer.class);
        }

        public PlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

