/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetGamificationProfileMetricsRequest {
    private String profileId;
    private List<String> expand;
    private LocalDate workday;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public GetGamificationProfileMetricsRequest withProfileId(String profileId) {
        this.setProfileId(profileId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetGamificationProfileMetricsRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public LocalDate getWorkday() {
        return this.workday;
    }

    public void setWorkday(LocalDate workday) {
        this.workday = workday;
    }

    public GetGamificationProfileMetricsRequest withWorkday(LocalDate workday) {
        this.setWorkday(workday);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGamificationProfileMetricsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.profileId == null) {
            throw new IllegalStateException("Missing the required parameter 'profileId' when building request for GetGamificationProfileMetricsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/gamification/profiles/{profileId}/metrics").withPathParameter("profileId", this.profileId).withQueryParameters("expand", "multi", this.expand).withQueryParameters("workday", "", this.workday).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String profileId) {
        return new Builder().withRequiredParams(profileId);
    }

    public static class Builder {
        private final GetGamificationProfileMetricsRequest request = new GetGamificationProfileMetricsRequest();

        private Builder() {
        }

        public Builder withProfileId(String profileId) {
            this.request.setProfileId(profileId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withWorkday(LocalDate workday) {
            this.request.setWorkday(workday);
            return this;
        }

        public Builder withRequiredParams(String profileId) {
            this.request.setProfileId(profileId);
            return this;
        }

        public GetGamificationProfileMetricsRequest build() {
            if (this.request.profileId == null) {
                throw new IllegalStateException("Missing the required parameter 'profileId' when building request for GetGamificationProfileMetricsRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        OBJECTIVE("objective");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

