/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningModuleRequest;
import java.util.HashMap;
import java.util.Map;

public class PutLearningModuleRequest {
    private String moduleId;
    private LearningModuleRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public PutLearningModuleRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public LearningModuleRequest getBody() {
        return this.body;
    }

    public void setBody(LearningModuleRequest body) {
        this.body = body;
    }

    public PutLearningModuleRequest withBody(LearningModuleRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutLearningModuleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningModuleRequest> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModuleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModuleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/learning/modules/{moduleId}").withPathParameter("moduleId", this.moduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, LearningModuleRequest body) {
        return new Builder().withRequiredParams(moduleId, body);
    }

    public static class Builder {
        private final PutLearningModuleRequest request = new PutLearningModuleRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withBody(LearningModuleRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String moduleId, LearningModuleRequest body) {
            this.request.setModuleId(moduleId);
            this.request.setBody(body);
            return this;
        }

        public PutLearningModuleRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModuleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModuleRequest.");
            }
            return this.request;
        }
    }
}

