/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest {
    private String knowledgeBaseId;
    private String languageCode;
    private String trainingId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public String getTrainingId() {
        return this.trainingId;
    }

    public void setTrainingId(String trainingId) {
        this.trainingId = trainingId;
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest withTrainingId(String trainingId) {
        this.setTrainingId(trainingId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
        }
        if (this.trainingId == null) {
            throw new IllegalStateException("Missing the required parameter 'trainingId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}/promote").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("languageCode", this.languageCode).withPathParameter("trainingId", this.trainingId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String languageCode, String trainingId) {
        return new Builder().withRequiredParams(knowledgeBaseId, languageCode, trainingId);
    }

    public static class Builder {
        private final PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest request = new PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withLanguageCode(languageCodeValues languageCode) {
            this.request.setLanguageCode(languageCode.toString());
            return this;
        }

        public Builder withTrainingId(String trainingId) {
            this.request.setTrainingId(trainingId);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String languageCode, String trainingId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLanguageCode(languageCode);
            this.request.setTrainingId(trainingId);
            return this;
        }

        public PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
            }
            if (this.request.trainingId == null) {
                throw new IllegalStateException("Missing the required parameter 'trainingId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingPromoteRequest.");
            }
            return this.request;
        }
    }

    public static enum languageCodeValues {
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        DE_DE("de-DE");

        private String value;

        private languageCodeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageCodeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageCodeValues value : languageCodeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageCodeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

