/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationEventCoBrowse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message event element.  Examples include: system messages, typing indicators, cobrowse offerings.")
public class ConversationMessageEvent
implements Serializable {
    private EventTypeEnum eventType = null;
    private ConversationEventCoBrowse coBrowse = null;

    public ConversationMessageEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this event element")
    @JsonProperty(value="eventType")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public ConversationMessageEvent coBrowse(ConversationEventCoBrowse coBrowse) {
        this.coBrowse = coBrowse;
        return this;
    }

    @ApiModelProperty(example="null", value="CoBrowse event.")
    @JsonProperty(value="coBrowse")
    public ConversationEventCoBrowse getCoBrowse() {
        return this.coBrowse;
    }

    public void setCoBrowse(ConversationEventCoBrowse coBrowse) {
        this.coBrowse = coBrowse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageEvent conversationMessageEvent = (ConversationMessageEvent)o;
        return Objects.equals((Object)this.eventType, (Object)conversationMessageEvent.eventType) && Objects.equals(this.coBrowse, conversationMessageEvent.coBrowse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.coBrowse});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageEvent {\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    coBrowse: ").append(this.toIndentedString(this.coBrowse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EventTypeEnumDeserializer.class)
    public static enum EventTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COBROWSE("CoBrowse");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EventTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EventTypeEnum value : EventTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EventTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EventTypeEnumDeserializer
    extends StdDeserializer<EventTypeEnum> {
        public EventTypeEnumDeserializer() {
            super(EventTypeEnumDeserializer.class);
        }

        public EventTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EventTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

