/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Metadata to associate with a given entity")
public class WfmVersionedEntityMetadata
implements Serializable {
    private Integer version = null;
    private UserReference modifiedBy = null;
    private Date dateModified = null;

    public WfmVersionedEntityMetadata version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the associated entity.  Used to prevent conflicts on concurrent edits")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The user who last modified the associated entity")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="The date the associated entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmVersionedEntityMetadata wfmVersionedEntityMetadata = (WfmVersionedEntityMetadata)o;
        return Objects.equals(this.version, wfmVersionedEntityMetadata.version) && Objects.equals(this.modifiedBy, wfmVersionedEntityMetadata.modifiedBy) && Objects.equals(this.dateModified, wfmVersionedEntityMetadata.dateModified);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.modifiedBy, this.dateModified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmVersionedEntityMetadata {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

