/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class FacebookIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private String appId = null;
    private String pageId = null;
    private String pageName = null;
    private String pageProfileImageUrl = null;
    private String status = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private CreateStatusEnum createStatus = null;
    private ErrorBody createError = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FacebookIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Facebook Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FacebookIntegration appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The App Id from Facebook messenger")
    @JsonProperty(value="appId")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public FacebookIntegration pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Page Id from Facebook messenger")
    @JsonProperty(value="pageId")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @ApiModelProperty(example="null", value="The name of the Facebook page")
    @JsonProperty(value="pageName")
    public String getPageName() {
        return this.pageName;
    }

    @ApiModelProperty(example="null", value="The url of the profile image of the Facebook page")
    @JsonProperty(value="pageProfileImageUrl")
    public String getPageProfileImageUrl() {
        return this.pageProfileImageUrl;
    }

    public FacebookIntegration status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the Facebook Integration")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(example="null", value="The recipient reference associated to the Facebook Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public FacebookIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public FacebookIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public FacebookIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public FacebookIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public FacebookIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="Status of asynchronous create operation")
    @JsonProperty(value="createStatus")
    public CreateStatusEnum getCreateStatus() {
        return this.createStatus;
    }

    @ApiModelProperty(example="null", value="Error information returned, if createStatus is set to Error")
    @JsonProperty(value="createError")
    public ErrorBody getCreateError() {
        return this.createError;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacebookIntegration facebookIntegration = (FacebookIntegration)o;
        return Objects.equals(this.id, facebookIntegration.id) && Objects.equals(this.name, facebookIntegration.name) && Objects.equals(this.appId, facebookIntegration.appId) && Objects.equals(this.pageId, facebookIntegration.pageId) && Objects.equals(this.pageName, facebookIntegration.pageName) && Objects.equals(this.pageProfileImageUrl, facebookIntegration.pageProfileImageUrl) && Objects.equals(this.status, facebookIntegration.status) && Objects.equals(this.recipient, facebookIntegration.recipient) && Objects.equals(this.dateCreated, facebookIntegration.dateCreated) && Objects.equals(this.dateModified, facebookIntegration.dateModified) && Objects.equals(this.createdBy, facebookIntegration.createdBy) && Objects.equals(this.modifiedBy, facebookIntegration.modifiedBy) && Objects.equals(this.version, facebookIntegration.version) && Objects.equals((Object)this.createStatus, (Object)facebookIntegration.createStatus) && Objects.equals(this.createError, facebookIntegration.createError) && Objects.equals(this.selfUri, facebookIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.appId, this.pageId, this.pageName, this.pageProfileImageUrl, this.status, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.createStatus, this.createError, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FacebookIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    pageName: ").append(this.toIndentedString(this.pageName)).append("\n");
        sb.append("    pageProfileImageUrl: ").append(this.toIndentedString(this.pageProfileImageUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createStatus: ").append(this.toIndentedString((Object)this.createStatus)).append("\n");
        sb.append("    createError: ").append(this.toIndentedString(this.createError)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CreateStatusEnumDeserializer.class)
    public static enum CreateStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATED("Initiated"),
        COMPLETED("Completed"),
        ERROR("Error");

        private String value;

        private CreateStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreateStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreateStatusEnum value : CreateStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreateStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CreateStatusEnumDeserializer
    extends StdDeserializer<CreateStatusEnum> {
        public CreateStatusEnumDeserializer() {
            super(CreateStatusEnumDeserializer.class);
        }

        public CreateStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CreateStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

