/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WorkdayValuesMetricItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SingleWorkdayAverageValues
implements Serializable {
    private LocalDate dateWorkday = null;
    private Division division = null;
    private UserReference user = null;
    private String timezone = null;
    private List<WorkdayValuesMetricItem> results = new ArrayList<WorkdayValuesMetricItem>();

    @ApiModelProperty(example="null", value="The targeted workday for average value query. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateWorkday")
    public LocalDate getDateWorkday() {
        return this.dateWorkday;
    }

    @ApiModelProperty(example="null", value="The targeted division for the metrics")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    @ApiModelProperty(example="null", value="The targeted user for the metrics")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="The time zone used for aggregating metric values")
    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @ApiModelProperty(example="null", value="The metric value averages")
    @JsonProperty(value="results")
    public List<WorkdayValuesMetricItem> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleWorkdayAverageValues singleWorkdayAverageValues = (SingleWorkdayAverageValues)o;
        return Objects.equals(this.dateWorkday, singleWorkdayAverageValues.dateWorkday) && Objects.equals(this.division, singleWorkdayAverageValues.division) && Objects.equals(this.user, singleWorkdayAverageValues.user) && Objects.equals(this.timezone, singleWorkdayAverageValues.timezone) && Objects.equals(this.results, singleWorkdayAverageValues.results);
    }

    public int hashCode() {
        return Objects.hash(this.dateWorkday, this.division, this.user, this.timezone, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleWorkdayAverageValues {\n");
        sb.append("    dateWorkday: ").append(this.toIndentedString(this.dateWorkday)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

