/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.NluDomain;
import java.util.HashMap;
import java.util.Map;

public class PatchLanguageunderstandingDomainRequest {
    private String domainId;
    private NluDomain body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public PatchLanguageunderstandingDomainRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public NluDomain getBody() {
        return this.body;
    }

    public void setBody(NluDomain body) {
        this.body = body;
    }

    public PatchLanguageunderstandingDomainRequest withBody(NluDomain body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchLanguageunderstandingDomainRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<NluDomain> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PatchLanguageunderstandingDomainRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLanguageunderstandingDomainRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/languageunderstanding/domains/{domainId}").withPathParameter("domainId", this.domainId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId, NluDomain body) {
        return new Builder().withRequiredParams(domainId, body);
    }

    public static class Builder {
        private final PatchLanguageunderstandingDomainRequest request = new PatchLanguageunderstandingDomainRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withBody(NluDomain body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainId, NluDomain body) {
            this.request.setDomainId(domainId);
            this.request.setBody(body);
            return this;
        }

        public PatchLanguageunderstandingDomainRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PatchLanguageunderstandingDomainRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLanguageunderstandingDomainRequest.");
            }
            return this.request;
        }
    }
}

