/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Objective;
import com.mypurecloud.sdk.v2.model.PerformanceProfile;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;

public class Metric
implements Serializable {
    private String id = null;
    private String name = null;
    private String metricDefinitionId = null;
    private String externalMetricDefinitionId = null;
    private Objective objective = null;
    private String performanceProfileId = null;
    private AddressableEntityRef linkedMetric = null;
    private Date dateCreated = null;
    private LocalDate dateUnlinked = null;
    private PerformanceProfile sourcePerformanceProfile = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Metric name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this metric")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Metric metricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated metric definition")
    @JsonProperty(value="metricDefinitionId")
    public String getMetricDefinitionId() {
        return this.metricDefinitionId;
    }

    public void setMetricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
    }

    public Metric externalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated external metric definition")
    @JsonProperty(value="externalMetricDefinitionId")
    public String getExternalMetricDefinitionId() {
        return this.externalMetricDefinitionId;
    }

    public void setExternalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
    }

    public Metric objective(Objective objective) {
        this.objective = objective;
        return this;
    }

    @ApiModelProperty(example="null", value="Associated objective for this metric")
    @JsonProperty(value="objective")
    public Objective getObjective() {
        return this.objective;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public Metric performanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
        return this;
    }

    @ApiModelProperty(example="null", value="Performance profile id of this metric")
    @JsonProperty(value="performanceProfileId")
    public String getPerformanceProfileId() {
        return this.performanceProfileId;
    }

    public void setPerformanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
    }

    public Metric linkedMetric(AddressableEntityRef linkedMetric) {
        this.linkedMetric = linkedMetric;
        return this;
    }

    @ApiModelProperty(example="null", value="The linked metric entity reference")
    @JsonProperty(value="linkedMetric")
    public AddressableEntityRef getLinkedMetric() {
        return this.linkedMetric;
    }

    public void setLinkedMetric(AddressableEntityRef linkedMetric) {
        this.linkedMetric = linkedMetric;
    }

    @ApiModelProperty(example="null", value="The created date of this metric. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The unlinked workday for this metric if this metric was ever unlinked. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateUnlinked")
    public LocalDate getDateUnlinked() {
        return this.dateUnlinked;
    }

    public Metric sourcePerformanceProfile(PerformanceProfile sourcePerformanceProfile) {
        this.sourcePerformanceProfile = sourcePerformanceProfile;
        return this;
    }

    @ApiModelProperty(example="null", value="The source performance profile when this metric is linked")
    @JsonProperty(value="sourcePerformanceProfile")
    public PerformanceProfile getSourcePerformanceProfile() {
        return this.sourcePerformanceProfile;
    }

    public void setSourcePerformanceProfile(PerformanceProfile sourcePerformanceProfile) {
        this.sourcePerformanceProfile = sourcePerformanceProfile;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.id, metric.id) && Objects.equals(this.name, metric.name) && Objects.equals(this.metricDefinitionId, metric.metricDefinitionId) && Objects.equals(this.externalMetricDefinitionId, metric.externalMetricDefinitionId) && Objects.equals(this.objective, metric.objective) && Objects.equals(this.performanceProfileId, metric.performanceProfileId) && Objects.equals(this.linkedMetric, metric.linkedMetric) && Objects.equals(this.dateCreated, metric.dateCreated) && Objects.equals(this.dateUnlinked, metric.dateUnlinked) && Objects.equals(this.sourcePerformanceProfile, metric.sourcePerformanceProfile) && Objects.equals(this.selfUri, metric.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.metricDefinitionId, this.externalMetricDefinitionId, this.objective, this.performanceProfileId, this.linkedMetric, this.dateCreated, this.dateUnlinked, this.sourcePerformanceProfile, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metric {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    metricDefinitionId: ").append(this.toIndentedString(this.metricDefinitionId)).append("\n");
        sb.append("    externalMetricDefinitionId: ").append(this.toIndentedString(this.externalMetricDefinitionId)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    performanceProfileId: ").append(this.toIndentedString(this.performanceProfileId)).append("\n");
        sb.append("    linkedMetric: ").append(this.toIndentedString(this.linkedMetric)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateUnlinked: ").append(this.toIndentedString(this.dateUnlinked)).append("\n");
        sb.append("    sourcePerformanceProfile: ").append(this.toIndentedString(this.sourcePerformanceProfile)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

