/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.LanguageReference;
import com.mypurecloud.sdk.v2.model.QueueReference;
import com.mypurecloud.sdk.v2.model.RoutingSkillReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Route path configuration")
public class RoutePathResponse
implements Serializable {
    private QueueReference queue = null;
    private MediaTypeEnum mediaType = null;
    private LanguageReference language = null;
    private List<RoutingSkillReference> skills = new ArrayList<RoutingSkillReference>();

    public RoutePathResponse queue(QueueReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the queue associated with the route path")
    @JsonProperty(value="queue")
    public QueueReference getQueue() {
        return this.queue;
    }

    public void setQueue(QueueReference queue) {
        this.queue = queue;
    }

    public RoutePathResponse mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the given queue associated with the route path")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public RoutePathResponse language(LanguageReference language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the language associated with the route path")
    @JsonProperty(value="language")
    public LanguageReference getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageReference language) {
        this.language = language;
    }

    public RoutePathResponse skills(List<RoutingSkillReference> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of skills associated with the route path")
    @JsonProperty(value="skills")
    public List<RoutingSkillReference> getSkills() {
        return this.skills;
    }

    public void setSkills(List<RoutingSkillReference> skills) {
        this.skills = skills;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutePathResponse routePathResponse = (RoutePathResponse)o;
        return Objects.equals(this.queue, routePathResponse.queue) && Objects.equals((Object)this.mediaType, (Object)routePathResponse.mediaType) && Objects.equals(this.language, routePathResponse.language) && Objects.equals(this.skills, routePathResponse.skills);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queue, this.mediaType, this.language, this.skills});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutePathResponse {\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        CHAT("Chat"),
        EMAIL("Email"),
        CALLBACK("Callback"),
        MESSAGE("Message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

