/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.LeaderboardItem;
import com.mypurecloud.sdk.v2.model.Metric;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Leaderboard
implements Serializable {
    private Division division = null;
    private Metric metric = null;
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;
    private List<LeaderboardItem> leaders = new ArrayList<LeaderboardItem>();
    private LeaderboardItem userRank = null;

    public Leaderboard division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted division for this leaderboard")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public Leaderboard metric(Metric metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The metric id if the leaderboard is about a specific metric")
    @JsonProperty(value="metric")
    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    @ApiModelProperty(example="null", value="Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    @ApiModelProperty(example="null", value="End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    public Leaderboard leaders(List<LeaderboardItem> leaders) {
        this.leaders = leaders;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of leaders generated.")
    @JsonProperty(value="leaders")
    public List<LeaderboardItem> getLeaders() {
        return this.leaders;
    }

    public void setLeaders(List<LeaderboardItem> leaders) {
        this.leaders = leaders;
    }

    public Leaderboard userRank(LeaderboardItem userRank) {
        this.userRank = userRank;
        return this;
    }

    @ApiModelProperty(example="null", value="The requesting user's rank")
    @JsonProperty(value="userRank")
    public LeaderboardItem getUserRank() {
        return this.userRank;
    }

    public void setUserRank(LeaderboardItem userRank) {
        this.userRank = userRank;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Leaderboard leaderboard = (Leaderboard)o;
        return Objects.equals(this.division, leaderboard.division) && Objects.equals(this.metric, leaderboard.metric) && Objects.equals(this.dateStartWorkday, leaderboard.dateStartWorkday) && Objects.equals(this.dateEndWorkday, leaderboard.dateEndWorkday) && Objects.equals(this.leaders, leaderboard.leaders) && Objects.equals(this.userRank, leaderboard.userRank);
    }

    public int hashCode() {
        return Objects.hash(this.division, this.metric, this.dateStartWorkday, this.dateEndWorkday, this.leaders, this.userRank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Leaderboard {\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("    leaders: ").append(this.toIndentedString(this.leaders)).append("\n");
        sb.append("    userRank: ").append(this.toIndentedString(this.userRank)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

