/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WfmScheduleReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AvailableTime
implements Serializable {
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private Boolean isPaid = null;
    private ActivityCategoryEnum activityCategory = null;
    private WfmScheduleReference wfmSchedule = null;

    @ApiModelProperty(example="null", value="Start of the availability period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    @ApiModelProperty(example="null", value="Length of availability period in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    @ApiModelProperty(example="null", value="Indicates if this availability period is paid in Workforce Management schedule")
    @JsonProperty(value="isPaid")
    public Boolean getIsPaid() {
        return this.isPaid;
    }

    @ApiModelProperty(example="null", value="Workforce Management activity category for this availability period")
    @JsonProperty(value="activityCategory")
    public ActivityCategoryEnum getActivityCategory() {
        return this.activityCategory;
    }

    public AvailableTime wfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
        return this;
    }

    @ApiModelProperty(example="null", value="Workforce Management schedule information associated with the available time")
    @JsonProperty(value="wfmSchedule")
    public WfmScheduleReference getWfmSchedule() {
        return this.wfmSchedule;
    }

    public void setWfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableTime availableTime = (AvailableTime)o;
        return Objects.equals(this.dateStart, availableTime.dateStart) && Objects.equals(this.lengthInMinutes, availableTime.lengthInMinutes) && Objects.equals(this.isPaid, availableTime.isPaid) && Objects.equals((Object)this.activityCategory, (Object)availableTime.activityCategory) && Objects.equals(this.wfmSchedule, availableTime.wfmSchedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateStart, this.lengthInMinutes, this.isPaid, this.activityCategory, this.wfmSchedule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableTime {\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    isPaid: ").append(this.toIndentedString(this.isPaid)).append("\n");
        sb.append("    activityCategory: ").append(this.toIndentedString((Object)this.activityCategory)).append("\n");
        sb.append("    wfmSchedule: ").append(this.toIndentedString(this.wfmSchedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivityCategoryEnumDeserializer.class)
    public static enum ActivityCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable");

        private String value;

        private ActivityCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivityCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivityCategoryEnum value : ActivityCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivityCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivityCategoryEnumDeserializer
    extends StdDeserializer<ActivityCategoryEnum> {
        public ActivityCategoryEnumDeserializer() {
            super(ActivityCategoryEnumDeserializer.class);
        }

        public ActivityCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivityCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

