/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Metric;
import java.util.HashMap;
import java.util.Map;

public class PutGamificationMetricRequest {
    private String metricId;
    private Metric body;
    private String performanceProfileId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public PutGamificationMetricRequest withMetricId(String metricId) {
        this.setMetricId(metricId);
        return this;
    }

    public Metric getBody() {
        return this.body;
    }

    public void setBody(Metric body) {
        this.body = body;
    }

    public PutGamificationMetricRequest withBody(Metric body) {
        this.setBody(body);
        return this;
    }

    public String getPerformanceProfileId() {
        return this.performanceProfileId;
    }

    public void setPerformanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
    }

    public PutGamificationMetricRequest withPerformanceProfileId(String performanceProfileId) {
        this.setPerformanceProfileId(performanceProfileId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutGamificationMetricRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Metric> withHttpInfo() {
        if (this.metricId == null) {
            throw new IllegalStateException("Missing the required parameter 'metricId' when building request for PutGamificationMetricRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGamificationMetricRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/gamification/metrics/{metricId}").withPathParameter("metricId", this.metricId).withQueryParameters("performance profile id", "", this.performanceProfileId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String metricId, Metric body) {
        return new Builder().withRequiredParams(metricId, body);
    }

    public static class Builder {
        private final PutGamificationMetricRequest request = new PutGamificationMetricRequest();

        private Builder() {
        }

        public Builder withMetricId(String metricId) {
            this.request.setMetricId(metricId);
            return this;
        }

        public Builder withBody(Metric body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withPerformanceProfileId(String performanceProfileId) {
            this.request.setPerformanceProfileId(performanceProfileId);
            return this;
        }

        public Builder withRequiredParams(String metricId, Metric body) {
            this.request.setMetricId(metricId);
            this.request.setBody(body);
            return this;
        }

        public PutGamificationMetricRequest build() {
            if (this.request.metricId == null) {
                throw new IllegalStateException("Missing the required parameter 'metricId' when building request for PutGamificationMetricRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGamificationMetricRequest.");
            }
            return this.request;
        }
    }
}

