/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.IntentDefinition;
import com.mypurecloud.sdk.v2.model.NamedEntityDefinition;
import com.mypurecloud.sdk.v2.model.NamedEntityTypeDefinition;
import com.mypurecloud.sdk.v2.model.NluDomain;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class NluDomainVersion
implements Serializable {
    private String id = null;
    private NluDomain domain = null;
    private String description = null;
    private String language = null;
    private Boolean published = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date dateTrained = null;
    private Date datePublished = null;
    private TrainingStatusEnum trainingStatus = null;
    private EvaluationStatusEnum evaluationStatus = null;
    private List<IntentDefinition> intents = new ArrayList<IntentDefinition>();
    private List<NamedEntityTypeDefinition> entityTypes = new ArrayList<NamedEntityTypeDefinition>();
    private List<NamedEntityDefinition> entities = new ArrayList<NamedEntityDefinition>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public NluDomainVersion domain(NluDomain domain) {
        this.domain = domain;
        return this;
    }

    @ApiModelProperty(example="null", value="The NLU domain of the version.")
    @JsonProperty(value="domain")
    public NluDomain getDomain() {
        return this.domain;
    }

    public void setDomain(NluDomain domain) {
        this.domain = domain;
    }

    public NluDomainVersion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the NLU domain version.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NluDomainVersion language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The language that the NLU domain version supports.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @ApiModelProperty(example="null", value="Whether this NLU domain version has been published.")
    @JsonProperty(value="published")
    public Boolean getPublished() {
        return this.published;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain version was updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain version was trained. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateTrained")
    public Date getDateTrained() {
        return this.dateTrained;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain version was published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePublished")
    public Date getDatePublished() {
        return this.datePublished;
    }

    @ApiModelProperty(example="null", value="The training status of the NLU domain version.")
    @JsonProperty(value="trainingStatus")
    public TrainingStatusEnum getTrainingStatus() {
        return this.trainingStatus;
    }

    @ApiModelProperty(example="null", value="The evaluation status of the NLU domain version.")
    @JsonProperty(value="evaluationStatus")
    public EvaluationStatusEnum getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public NluDomainVersion intents(List<IntentDefinition> intents) {
        this.intents = intents;
        return this;
    }

    @ApiModelProperty(example="null", value="The intents defined for this NLU domain version.")
    @JsonProperty(value="intents")
    public List<IntentDefinition> getIntents() {
        return this.intents;
    }

    public void setIntents(List<IntentDefinition> intents) {
        this.intents = intents;
    }

    public NluDomainVersion entityTypes(List<NamedEntityTypeDefinition> entityTypes) {
        this.entityTypes = entityTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="The entity types defined for this NLU domain version.")
    @JsonProperty(value="entityTypes")
    public List<NamedEntityTypeDefinition> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(List<NamedEntityTypeDefinition> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public NluDomainVersion entities(List<NamedEntityDefinition> entities) {
        this.entities = entities;
        return this;
    }

    @ApiModelProperty(example="null", value="The entities defined for this NLU domain version.This field is mutually exclusive with entityTypeBindings")
    @JsonProperty(value="entities")
    public List<NamedEntityDefinition> getEntities() {
        return this.entities;
    }

    public void setEntities(List<NamedEntityDefinition> entities) {
        this.entities = entities;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NluDomainVersion nluDomainVersion = (NluDomainVersion)o;
        return Objects.equals(this.id, nluDomainVersion.id) && Objects.equals(this.domain, nluDomainVersion.domain) && Objects.equals(this.description, nluDomainVersion.description) && Objects.equals(this.language, nluDomainVersion.language) && Objects.equals(this.published, nluDomainVersion.published) && Objects.equals(this.dateCreated, nluDomainVersion.dateCreated) && Objects.equals(this.dateModified, nluDomainVersion.dateModified) && Objects.equals(this.dateTrained, nluDomainVersion.dateTrained) && Objects.equals(this.datePublished, nluDomainVersion.datePublished) && Objects.equals((Object)this.trainingStatus, (Object)nluDomainVersion.trainingStatus) && Objects.equals((Object)this.evaluationStatus, (Object)nluDomainVersion.evaluationStatus) && Objects.equals(this.intents, nluDomainVersion.intents) && Objects.equals(this.entityTypes, nluDomainVersion.entityTypes) && Objects.equals(this.entities, nluDomainVersion.entities) && Objects.equals(this.selfUri, nluDomainVersion.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.domain, this.description, this.language, this.published, this.dateCreated, this.dateModified, this.dateTrained, this.datePublished, this.trainingStatus, this.evaluationStatus, this.intents, this.entityTypes, this.entities, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NluDomainVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateTrained: ").append(this.toIndentedString(this.dateTrained)).append("\n");
        sb.append("    datePublished: ").append(this.toIndentedString(this.datePublished)).append("\n");
        sb.append("    trainingStatus: ").append(this.toIndentedString((Object)this.trainingStatus)).append("\n");
        sb.append("    evaluationStatus: ").append(this.toIndentedString((Object)this.evaluationStatus)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    entityTypes: ").append(this.toIndentedString(this.entityTypes)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EvaluationStatusEnumDeserializer.class)
    public static enum EvaluationStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNEVALUATED("Unevaluated"),
        EVALUATING("Evaluating"),
        EVALUATED("Evaluated"),
        ERROR("Error");

        private String value;

        private EvaluationStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EvaluationStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EvaluationStatusEnum value : EvaluationStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EvaluationStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EvaluationStatusEnumDeserializer
    extends StdDeserializer<EvaluationStatusEnum> {
        public EvaluationStatusEnumDeserializer() {
            super(EvaluationStatusEnumDeserializer.class);
        }

        public EvaluationStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EvaluationStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TrainingStatusEnumDeserializer.class)
    public static enum TrainingStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNTRAINED("Untrained"),
        TRAINING("Training"),
        TRAINED("Trained"),
        ERROR("Error"),
        UNKNOWN("Unknown");

        private String value;

        private TrainingStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TrainingStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TrainingStatusEnum value : TrainingStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TrainingStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TrainingStatusEnumDeserializer
    extends StdDeserializer<TrainingStatusEnum> {
        public TrainingStatusEnumDeserializer() {
            super(TrainingStatusEnumDeserializer.class);
        }

        public TrainingStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TrainingStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

