/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AnalyticsEvaluation
implements Serializable {
    private String calibrationId = null;
    private String contextId = null;
    private Boolean deleted = null;
    private String evaluationId = null;
    private String evaluatorId = null;
    private Date eventTime = null;
    private String formId = null;
    private String formName = null;
    private String queueId = null;
    private Boolean rescored = null;
    private String userId = null;
    private Long getoTotalCriticalScore = null;
    private Long getoTotalScore = null;

    public AnalyticsEvaluation calibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The calibration ID used for the purpose of training evaluators")
    @JsonProperty(value="calibrationId")
    public String getCalibrationId() {
        return this.calibrationId;
    }

    public void setCalibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
    }

    public AnalyticsEvaluation contextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for an evaluation form, regardless of version")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public AnalyticsEvaluation deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation has been deleted")
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public AnalyticsEvaluation evaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the evaluation")
    @JsonProperty(value="evaluationId")
    public String getEvaluationId() {
        return this.evaluationId;
    }

    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public AnalyticsEvaluation evaluatorId(String evaluatorId) {
        this.evaluatorId = evaluatorId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier of the user who evaluated the interaction")
    @JsonProperty(value="evaluatorId")
    public String getEvaluatorId() {
        return this.evaluatorId;
    }

    public void setEvaluatorId(String evaluatorId) {
        this.evaluatorId = evaluatorId;
    }

    public AnalyticsEvaluation eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies when an evaluation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventTime")
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public AnalyticsEvaluation formId(String formId) {
        this.formId = formId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the evaluation form used")
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public AnalyticsEvaluation formName(String formName) {
        this.formName = formName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the evaluation form used")
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public AnalyticsEvaluation queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the associated queue")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public AnalyticsEvaluation rescored(Boolean rescored) {
        this.rescored = rescored;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation has been rescored at least once")
    @JsonProperty(value="rescored")
    public Boolean getRescored() {
        return this.rescored;
    }

    public void setRescored(Boolean rescored) {
        this.rescored = rescored;
    }

    public AnalyticsEvaluation userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the agent the evaluation was performed against")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AnalyticsEvaluation getoTotalCriticalScore(Long getoTotalCriticalScore) {
        this.getoTotalCriticalScore = getoTotalCriticalScore;
        return this;
    }

    @ApiModelProperty(example="null", value="Total critical score of the evaluation")
    @JsonProperty(value="getoTotalCriticalScore")
    public Long getGetoTotalCriticalScore() {
        return this.getoTotalCriticalScore;
    }

    public void setGetoTotalCriticalScore(Long getoTotalCriticalScore) {
        this.getoTotalCriticalScore = getoTotalCriticalScore;
    }

    public AnalyticsEvaluation getoTotalScore(Long getoTotalScore) {
        this.getoTotalScore = getoTotalScore;
        return this;
    }

    @ApiModelProperty(example="null", value="Total score of the evaluation")
    @JsonProperty(value="getoTotalScore")
    public Long getGetoTotalScore() {
        return this.getoTotalScore;
    }

    public void setGetoTotalScore(Long getoTotalScore) {
        this.getoTotalScore = getoTotalScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsEvaluation analyticsEvaluation = (AnalyticsEvaluation)o;
        return Objects.equals(this.calibrationId, analyticsEvaluation.calibrationId) && Objects.equals(this.contextId, analyticsEvaluation.contextId) && Objects.equals(this.deleted, analyticsEvaluation.deleted) && Objects.equals(this.evaluationId, analyticsEvaluation.evaluationId) && Objects.equals(this.evaluatorId, analyticsEvaluation.evaluatorId) && Objects.equals(this.eventTime, analyticsEvaluation.eventTime) && Objects.equals(this.formId, analyticsEvaluation.formId) && Objects.equals(this.formName, analyticsEvaluation.formName) && Objects.equals(this.queueId, analyticsEvaluation.queueId) && Objects.equals(this.rescored, analyticsEvaluation.rescored) && Objects.equals(this.userId, analyticsEvaluation.userId) && Objects.equals(this.getoTotalCriticalScore, analyticsEvaluation.getoTotalCriticalScore) && Objects.equals(this.getoTotalScore, analyticsEvaluation.getoTotalScore);
    }

    public int hashCode() {
        return Objects.hash(this.calibrationId, this.contextId, this.deleted, this.evaluationId, this.evaluatorId, this.eventTime, this.formId, this.formName, this.queueId, this.rescored, this.userId, this.getoTotalCriticalScore, this.getoTotalScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsEvaluation {\n");
        sb.append("    calibrationId: ").append(this.toIndentedString(this.calibrationId)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    evaluationId: ").append(this.toIndentedString(this.evaluationId)).append("\n");
        sb.append("    evaluatorId: ").append(this.toIndentedString(this.evaluatorId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    formId: ").append(this.toIndentedString(this.formId)).append("\n");
        sb.append("    formName: ").append(this.toIndentedString(this.formName)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    rescored: ").append(this.toIndentedString(this.rescored)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    getoTotalCriticalScore: ").append(this.toIndentedString(this.getoTotalCriticalScore)).append("\n");
        sb.append("    getoTotalScore: ").append(this.toIndentedString(this.getoTotalScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

