/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Operation;
import com.mypurecloud.sdk.v2.model.PromptAsset;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Prompt
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private List<PromptAsset> resources = new ArrayList<PromptAsset>();
    private Operation currentOperation = null;
    private String selfUri = null;

    public Prompt id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The prompt identifier")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Prompt name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The prompt name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Prompt description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Prompt resources(List<PromptAsset> resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="List of resources associated with this prompt")
    @JsonProperty(value="resources")
    public List<PromptAsset> getResources() {
        return this.resources;
    }

    public void setResources(List<PromptAsset> resources) {
        this.resources = resources;
    }

    public Prompt currentOperation(Operation currentOperation) {
        this.currentOperation = currentOperation;
        return this;
    }

    @ApiModelProperty(example="null", value="Current prompt operation status")
    @JsonProperty(value="currentOperation")
    public Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(Operation currentOperation) {
        this.currentOperation = currentOperation;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prompt prompt = (Prompt)o;
        return Objects.equals(this.id, prompt.id) && Objects.equals(this.name, prompt.name) && Objects.equals(this.description, prompt.description) && Objects.equals(this.resources, prompt.resources) && Objects.equals(this.currentOperation, prompt.currentOperation) && Objects.equals(this.selfUri, prompt.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.resources, this.currentOperation, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Prompt {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    currentOperation: ").append(this.toIndentedString(this.currentOperation)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

