/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AnalyticsFlowOutcome;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnalyticsFlow
implements Serializable {
    private String endingLanguage = null;
    private String entryReason = null;
    private EntryTypeEnum entryType = null;
    private String exitReason = null;
    private String flowId = null;
    private String flowName = null;
    private FlowTypeEnum flowType = null;
    private String flowVersion = null;
    private Boolean issuedCallback = null;
    private String recognitionFailureReason = null;
    private String startingLanguage = null;
    private String transferTargetAddress = null;
    private String transferTargetName = null;
    private String transferType = null;
    private List<AnalyticsFlowOutcome> outcomes = new ArrayList<AnalyticsFlowOutcome>();

    public AnalyticsFlow endingLanguage(String endingLanguage) {
        this.endingLanguage = endingLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="Flow ending language, e.g. en-us")
    @JsonProperty(value="endingLanguage")
    public String getEndingLanguage() {
        return this.endingLanguage;
    }

    public void setEndingLanguage(String endingLanguage) {
        this.endingLanguage = endingLanguage;
    }

    public AnalyticsFlow entryReason(String entryReason) {
        this.entryReason = entryReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The particular entry reason for this flow, e.g. an address, userId, or flowId")
    @JsonProperty(value="entryReason")
    public String getEntryReason() {
        return this.entryReason;
    }

    public void setEntryReason(String entryReason) {
        this.entryReason = entryReason;
    }

    public AnalyticsFlow entryType(EntryTypeEnum entryType) {
        this.entryType = entryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The entry type for this flow, e.g. dnis, dialer, agent, flow, or direct")
    @JsonProperty(value="entryType")
    public EntryTypeEnum getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntryTypeEnum entryType) {
        this.entryType = entryType;
    }

    public AnalyticsFlow exitReason(String exitReason) {
        this.exitReason = exitReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The exit reason for this flow, e.g. DISCONNECT")
    @JsonProperty(value="exitReason")
    public String getExitReason() {
        return this.exitReason;
    }

    public void setExitReason(String exitReason) {
        this.exitReason = exitReason;
    }

    public AnalyticsFlow flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of this flow")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public AnalyticsFlow flowName(String flowName) {
        this.flowName = flowName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of this flow at the time of flow execution")
    @JsonProperty(value="flowName")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public AnalyticsFlow flowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this flow")
    @JsonProperty(value="flowType")
    public FlowTypeEnum getFlowType() {
        return this.flowType;
    }

    public void setFlowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
    }

    public AnalyticsFlow flowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of this flow")
    @JsonProperty(value="flowVersion")
    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public AnalyticsFlow issuedCallback(Boolean issuedCallback) {
        this.issuedCallback = issuedCallback;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag indicating whether the flow issued a callback")
    @JsonProperty(value="issuedCallback")
    public Boolean getIssuedCallback() {
        return this.issuedCallback;
    }

    public void setIssuedCallback(Boolean issuedCallback) {
        this.issuedCallback = issuedCallback;
    }

    public AnalyticsFlow recognitionFailureReason(String recognitionFailureReason) {
        this.recognitionFailureReason = recognitionFailureReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The recognition failure reason causing to exit/disconnect")
    @JsonProperty(value="recognitionFailureReason")
    public String getRecognitionFailureReason() {
        return this.recognitionFailureReason;
    }

    public void setRecognitionFailureReason(String recognitionFailureReason) {
        this.recognitionFailureReason = recognitionFailureReason;
    }

    public AnalyticsFlow startingLanguage(String startingLanguage) {
        this.startingLanguage = startingLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="Flow starting language, e.g. en-us")
    @JsonProperty(value="startingLanguage")
    public String getStartingLanguage() {
        return this.startingLanguage;
    }

    public void setStartingLanguage(String startingLanguage) {
        this.startingLanguage = startingLanguage;
    }

    public AnalyticsFlow transferTargetAddress(String transferTargetAddress) {
        this.transferTargetAddress = transferTargetAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The address of a flow transfer target, e.g. a phone number, an email address, or a queueId")
    @JsonProperty(value="transferTargetAddress")
    public String getTransferTargetAddress() {
        return this.transferTargetAddress;
    }

    public void setTransferTargetAddress(String transferTargetAddress) {
        this.transferTargetAddress = transferTargetAddress;
    }

    public AnalyticsFlow transferTargetName(String transferTargetName) {
        this.transferTargetName = transferTargetName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of a flow transfer target")
    @JsonProperty(value="transferTargetName")
    public String getTransferTargetName() {
        return this.transferTargetName;
    }

    public void setTransferTargetName(String transferTargetName) {
        this.transferTargetName = transferTargetName;
    }

    public AnalyticsFlow transferType(String transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of transfer for flows that ended with a transfer")
    @JsonProperty(value="transferType")
    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public AnalyticsFlow outcomes(List<AnalyticsFlowOutcome> outcomes) {
        this.outcomes = outcomes;
        return this;
    }

    @ApiModelProperty(example="null", value="Flow outcomes")
    @JsonProperty(value="outcomes")
    public List<AnalyticsFlowOutcome> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(List<AnalyticsFlowOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsFlow analyticsFlow = (AnalyticsFlow)o;
        return Objects.equals(this.endingLanguage, analyticsFlow.endingLanguage) && Objects.equals(this.entryReason, analyticsFlow.entryReason) && Objects.equals((Object)this.entryType, (Object)analyticsFlow.entryType) && Objects.equals(this.exitReason, analyticsFlow.exitReason) && Objects.equals(this.flowId, analyticsFlow.flowId) && Objects.equals(this.flowName, analyticsFlow.flowName) && Objects.equals((Object)this.flowType, (Object)analyticsFlow.flowType) && Objects.equals(this.flowVersion, analyticsFlow.flowVersion) && Objects.equals(this.issuedCallback, analyticsFlow.issuedCallback) && Objects.equals(this.recognitionFailureReason, analyticsFlow.recognitionFailureReason) && Objects.equals(this.startingLanguage, analyticsFlow.startingLanguage) && Objects.equals(this.transferTargetAddress, analyticsFlow.transferTargetAddress) && Objects.equals(this.transferTargetName, analyticsFlow.transferTargetName) && Objects.equals(this.transferType, analyticsFlow.transferType) && Objects.equals(this.outcomes, analyticsFlow.outcomes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endingLanguage, this.entryReason, this.entryType, this.exitReason, this.flowId, this.flowName, this.flowType, this.flowVersion, this.issuedCallback, this.recognitionFailureReason, this.startingLanguage, this.transferTargetAddress, this.transferTargetName, this.transferType, this.outcomes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsFlow {\n");
        sb.append("    endingLanguage: ").append(this.toIndentedString(this.endingLanguage)).append("\n");
        sb.append("    entryReason: ").append(this.toIndentedString(this.entryReason)).append("\n");
        sb.append("    entryType: ").append(this.toIndentedString((Object)this.entryType)).append("\n");
        sb.append("    exitReason: ").append(this.toIndentedString(this.exitReason)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    flowName: ").append(this.toIndentedString(this.flowName)).append("\n");
        sb.append("    flowType: ").append(this.toIndentedString((Object)this.flowType)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString(this.flowVersion)).append("\n");
        sb.append("    issuedCallback: ").append(this.toIndentedString(this.issuedCallback)).append("\n");
        sb.append("    recognitionFailureReason: ").append(this.toIndentedString(this.recognitionFailureReason)).append("\n");
        sb.append("    startingLanguage: ").append(this.toIndentedString(this.startingLanguage)).append("\n");
        sb.append("    transferTargetAddress: ").append(this.toIndentedString(this.transferTargetAddress)).append("\n");
        sb.append("    transferTargetName: ").append(this.toIndentedString(this.transferTargetName)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString(this.transferType)).append("\n");
        sb.append("    outcomes: ").append(this.toIndentedString(this.outcomes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FlowTypeEnumDeserializer.class)
    public static enum FlowTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("BOT"),
        COMMONMODULE("COMMONMODULE"),
        INBOUNDCALL("INBOUNDCALL"),
        INBOUNDCHAT("INBOUNDCHAT"),
        INBOUNDEMAIL("INBOUNDEMAIL"),
        INBOUNDSHORTMESSAGE("INBOUNDSHORTMESSAGE"),
        INQUEUECALL("INQUEUECALL"),
        OUTBOUNDCALL("OUTBOUNDCALL"),
        SECURECALL("SECURECALL"),
        SPEECH("SPEECH"),
        SURVEYINVITE("SURVEYINVITE"),
        WORKFLOW("WORKFLOW");

        private String value;

        private FlowTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlowTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlowTypeEnum value : FlowTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlowTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlowTypeEnumDeserializer
    extends StdDeserializer<FlowTypeEnum> {
        public FlowTypeEnumDeserializer() {
            super(FlowTypeEnumDeserializer.class);
        }

        public FlowTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlowTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=EntryTypeEnumDeserializer.class)
    public static enum EntryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENT("agent"),
        DIRECT("direct"),
        DNIS("dnis"),
        FLOW("flow"),
        OUTBOUND("outbound");

        private String value;

        private EntryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntryTypeEnum value : EntryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EntryTypeEnumDeserializer
    extends StdDeserializer<EntryTypeEnum> {
        public EntryTypeEnumDeserializer() {
            super(EntryTypeEnumDeserializer.class);
        }

        public EntryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

