/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Flow;
import java.util.HashMap;
import java.util.Map;

public class PutFlowRequest {
    private String flowId;
    private Flow body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public PutFlowRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public Flow getBody() {
        return this.body;
    }

    public void setBody(Flow body) {
        this.body = body;
    }

    public PutFlowRequest withBody(Flow body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutFlowRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Flow> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PutFlowRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutFlowRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/flows/{flowId}").withPathParameter("flowId", this.flowId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId, Flow body) {
        return new Builder().withRequiredParams(flowId, body);
    }

    public static class Builder {
        private final PutFlowRequest request = new PutFlowRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withBody(Flow body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String flowId, Flow body) {
            this.request.setFlowId(flowId);
            this.request.setBody(body);
            return this;
        }

        public PutFlowRequest build() {
            if (this.request.flowId == null) {
                throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PutFlowRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutFlowRequest.");
            }
            return this.request;
        }
    }
}

