/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Library
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer version = null;
    private User createdBy = null;
    private Date dateCreated = null;
    private ResponseTypeEnum responseType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Library name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The library name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Current version for this resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public Library createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created the library.")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="The date and time the response was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Library responseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
        return this;
    }

    @ApiModelProperty(example="null", value="This value is deprecated. Responses representing message templates may be added to any library.")
    @JsonProperty(value="responseType")
    public ResponseTypeEnum getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        return Objects.equals(this.id, library.id) && Objects.equals(this.name, library.name) && Objects.equals(this.version, library.version) && Objects.equals(this.createdBy, library.createdBy) && Objects.equals(this.dateCreated, library.dateCreated) && Objects.equals((Object)this.responseType, (Object)library.responseType) && Objects.equals(this.selfUri, library.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.version, this.createdBy, this.dateCreated, this.responseType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Library {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    responseType: ").append(this.toIndentedString((Object)this.responseType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ResponseTypeEnumDeserializer.class)
    public static enum ResponseTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MESSAGINGTEMPLATE("MessagingTemplate"),
        CAMPAIGNSMSTEMPLATE("CampaignSmsTemplate"),
        CAMPAIGNEMAILTEMPLATE("CampaignEmailTemplate");

        private String value;

        private ResponseTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ResponseTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ResponseTypeEnum value : ResponseTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ResponseTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ResponseTypeEnumDeserializer
    extends StdDeserializer<ResponseTypeEnum> {
        public ResponseTypeEnumDeserializer() {
            super(ResponseTypeEnumDeserializer.class);
        }

        public ResponseTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ResponseTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

