/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class TransferRequest
implements Serializable {
    private String userId = null;
    private String address = null;
    private String userName = null;
    private String queueId = null;
    private Boolean voicemail = null;

    public TransferRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID of the transfer target.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TransferRequest address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number or address of the transfer target.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public TransferRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", value="The user name of the transfer target.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public TransferRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue ID of the transfer target.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public TransferRequest voicemail(Boolean voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, transfer to the voicemail inbox of the participant that is being replaced.")
    @JsonProperty(value="voicemail")
    public Boolean getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(Boolean voicemail) {
        this.voicemail = voicemail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRequest transferRequest = (TransferRequest)o;
        return Objects.equals(this.userId, transferRequest.userId) && Objects.equals(this.address, transferRequest.address) && Objects.equals(this.userName, transferRequest.userName) && Objects.equals(this.queueId, transferRequest.queueId) && Objects.equals(this.voicemail, transferRequest.voicemail);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.address, this.userName, this.queueId, this.voicemail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRequest {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString(this.voicemail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

