/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DataTableImportJob;
import java.util.HashMap;
import java.util.Map;

public class PostFlowsDatatableImportJobsRequest {
    private String datatableId;
    private DataTableImportJob body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public PostFlowsDatatableImportJobsRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public DataTableImportJob getBody() {
        return this.body;
    }

    public void setBody(DataTableImportJob body) {
        this.body = body;
    }

    public PostFlowsDatatableImportJobsRequest withBody(DataTableImportJob body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostFlowsDatatableImportJobsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DataTableImportJob> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PostFlowsDatatableImportJobsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowsDatatableImportJobsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/flows/datatables/{datatableId}/import/jobs").withPathParameter("datatableId", this.datatableId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId, DataTableImportJob body) {
        return new Builder().withRequiredParams(datatableId, body);
    }

    public static class Builder {
        private final PostFlowsDatatableImportJobsRequest request = new PostFlowsDatatableImportJobsRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withBody(DataTableImportJob body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String datatableId, DataTableImportJob body) {
            this.request.setDatatableId(datatableId);
            this.request.setBody(body);
            return this;
        }

        public PostFlowsDatatableImportJobsRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PostFlowsDatatableImportJobsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowsDatatableImportJobsRequest.");
            }
            return this.request;
        }
    }
}

