/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LocationUpdateDefinition;
import java.util.HashMap;
import java.util.Map;

public class PatchLocationRequest {
    private String locationId;
    private LocationUpdateDefinition body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public PatchLocationRequest withLocationId(String locationId) {
        this.setLocationId(locationId);
        return this;
    }

    public LocationUpdateDefinition getBody() {
        return this.body;
    }

    public void setBody(LocationUpdateDefinition body) {
        this.body = body;
    }

    public PatchLocationRequest withBody(LocationUpdateDefinition body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchLocationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LocationUpdateDefinition> withHttpInfo() {
        if (this.locationId == null) {
            throw new IllegalStateException("Missing the required parameter 'locationId' when building request for PatchLocationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLocationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/locations/{locationId}").withPathParameter("locationId", this.locationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String locationId, LocationUpdateDefinition body) {
        return new Builder().withRequiredParams(locationId, body);
    }

    public static class Builder {
        private final PatchLocationRequest request = new PatchLocationRequest();

        private Builder() {
        }

        public Builder withLocationId(String locationId) {
            this.request.setLocationId(locationId);
            return this;
        }

        public Builder withBody(LocationUpdateDefinition body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String locationId, LocationUpdateDefinition body) {
            this.request.setLocationId(locationId);
            this.request.setBody(body);
            return this;
        }

        public PatchLocationRequest build() {
            if (this.request.locationId == null) {
                throw new IllegalStateException("Missing the required parameter 'locationId' when building request for PatchLocationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLocationRequest.");
            }
            return this.request;
        }
    }
}

