/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ActionMapActionTemplate;
import com.mypurecloud.sdk.v2.model.ArchitectFlowFields;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ActionMapAction
implements Serializable {
    private ActionMapActionTemplate actionTemplate = null;
    private MediaTypeEnum mediaType = null;
    private ArchitectFlowFields architectFlowFields = null;

    public ActionMapAction actionTemplate(ActionMapActionTemplate actionTemplate) {
        this.actionTemplate = actionTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Action template associated with the action map.")
    @JsonProperty(value="actionTemplate")
    public ActionMapActionTemplate getActionTemplate() {
        return this.actionTemplate;
    }

    public void setActionTemplate(ActionMapActionTemplate actionTemplate) {
        this.actionTemplate = actionTemplate;
    }

    public ActionMapAction mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type of action.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ActionMapAction architectFlowFields(ArchitectFlowFields architectFlowFields) {
        this.architectFlowFields = architectFlowFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Architect Flow Id and input contract.")
    @JsonProperty(value="architectFlowFields")
    public ArchitectFlowFields getArchitectFlowFields() {
        return this.architectFlowFields;
    }

    public void setArchitectFlowFields(ArchitectFlowFields architectFlowFields) {
        this.architectFlowFields = architectFlowFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionMapAction actionMapAction = (ActionMapAction)o;
        return Objects.equals(this.actionTemplate, actionMapAction.actionTemplate) && Objects.equals((Object)this.mediaType, (Object)actionMapAction.mediaType) && Objects.equals(this.architectFlowFields, actionMapAction.architectFlowFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionTemplate, this.mediaType, this.architectFlowFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionMapAction {\n");
        sb.append("    actionTemplate: ").append(this.toIndentedString(this.actionTemplate)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    architectFlowFields: ").append(this.toIndentedString(this.architectFlowFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEBCHAT("webchat"),
        WEBMESSAGINGOFFER("webMessagingOffer"),
        CONTENTOFFER("contentOffer"),
        INTEGRATIONACTION("integrationAction"),
        ARCHITECTFLOW("architectFlow");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

