/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WebChatSettings;
import java.util.HashMap;
import java.util.Map;

public class PutWebchatSettingsRequest {
    private WebChatSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public WebChatSettings getBody() {
        return this.body;
    }

    public void setBody(WebChatSettings body) {
        this.body = body;
    }

    public PutWebchatSettingsRequest withBody(WebChatSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutWebchatSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WebChatSettings> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWebchatSettingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/webchat/settings").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebChatSettings body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PutWebchatSettingsRequest request = new PutWebchatSettingsRequest();

        private Builder() {
        }

        public Builder withBody(WebChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(WebChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public PutWebchatSettingsRequest build() {
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWebchatSettingsRequest.");
            }
            return this.request;
        }
    }
}

