/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Condition
implements Serializable {
    private TypeEnum type = null;
    private Boolean inverted = null;
    private String attributeName = null;
    private String value = null;
    private ValueTypeEnum valueType = null;
    private OperatorEnum operator = null;
    private List<String> codes = new ArrayList<String>();
    private String property = null;
    private PropertyTypeEnum propertyType = null;

    public Condition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the condition.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Condition inverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, inverts the result of evaluating this Condition. Default is false.")
    @JsonProperty(value="inverted")
    public Boolean getInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public Condition attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @ApiModelProperty(example="null", value="An attribute name associated with this Condition. Required for a contactAttributeCondition.")
    @JsonProperty(value="attributeName")
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Condition value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="A value associated with this Condition. This could be text, a number, or a relative time. Not used for a DataActionCondition.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Condition valueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the value associated with this Condition. Not used for a DataActionCondition.")
    @JsonProperty(value="valueType")
    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public Condition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="An operation with which to evaluate the Condition. Not used for a DataActionCondition.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public Condition codes(List<String> codes) {
        this.codes = codes;
        return this;
    }

    @ApiModelProperty(example="null", value="List of wrap-up code identifiers. Required for a wrapupCondition.")
    @JsonProperty(value="codes")
    public List<String> getCodes() {
        return this.codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public Condition property(String property) {
        this.property = property;
        return this;
    }

    @ApiModelProperty(example="null", value="A value associated with the property type of this Condition. Required for a contactPropertyCondition.")
    @JsonProperty(value="property")
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Condition propertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the property associated with this Condition. Required for a contactPropertyCondition.")
    @JsonProperty(value="propertyType")
    public PropertyTypeEnum getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals((Object)this.type, (Object)condition.type) && Objects.equals(this.inverted, condition.inverted) && Objects.equals(this.attributeName, condition.attributeName) && Objects.equals(this.value, condition.value) && Objects.equals((Object)this.valueType, (Object)condition.valueType) && Objects.equals((Object)this.operator, (Object)condition.operator) && Objects.equals(this.codes, condition.codes) && Objects.equals(this.property, condition.property) && Objects.equals((Object)this.propertyType, (Object)condition.propertyType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.inverted, this.attributeName, this.value, this.valueType, this.operator, this.codes, this.property, this.propertyType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    inverted: ").append(this.toIndentedString(this.inverted)).append("\n");
        sb.append("    attributeName: ").append(this.toIndentedString(this.attributeName)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString((Object)this.valueType)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    codes: ").append(this.toIndentedString(this.codes)).append("\n");
        sb.append("    property: ").append(this.toIndentedString(this.property)).append("\n");
        sb.append("    propertyType: ").append(this.toIndentedString((Object)this.propertyType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PropertyTypeEnumDeserializer.class)
    public static enum PropertyTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LAST_ATTEMPT_BY_COLUMN("LAST_ATTEMPT_BY_COLUMN"),
        LAST_ATTEMPT_OVERALL("LAST_ATTEMPT_OVERALL"),
        LAST_WRAPUP_BY_COLUMN("LAST_WRAPUP_BY_COLUMN"),
        LAST_WRAPUP_OVERALL("LAST_WRAPUP_OVERALL");

        private String value;

        private PropertyTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PropertyTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PropertyTypeEnum value : PropertyTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PropertyTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PropertyTypeEnumDeserializer
    extends StdDeserializer<PropertyTypeEnum> {
        public PropertyTypeEnumDeserializer() {
            super(PropertyTypeEnumDeserializer.class);
        }

        public PropertyTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PropertyTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("EQUALS"),
        LESS_THAN("LESS_THAN"),
        LESS_THAN_EQUALS("LESS_THAN_EQUALS"),
        GREATER_THAN("GREATER_THAN"),
        GREATER_THAN_EQUALS("GREATER_THAN_EQUALS"),
        CONTAINS("CONTAINS"),
        BEGINS_WITH("BEGINS_WITH"),
        ENDS_WITH("ENDS_WITH"),
        BEFORE("BEFORE"),
        AFTER("AFTER"),
        IN("IN");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ValueTypeEnumDeserializer.class)
    public static enum ValueTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("STRING"),
        NUMERIC("NUMERIC"),
        DATETIME("DATETIME"),
        PERIOD("PERIOD");

        private String value;

        private ValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ValueTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ValueTypeEnum value : ValueTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ValueTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ValueTypeEnumDeserializer
    extends StdDeserializer<ValueTypeEnum> {
        public ValueTypeEnumDeserializer() {
            super(ValueTypeEnumDeserializer.class);
        }

        public ValueTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ValueTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WRAPUPCONDITION("wrapupCondition"),
        CONTACTATTRIBUTECONDITION("contactAttributeCondition"),
        PHONENUMBERCONDITION("phoneNumberCondition"),
        PHONENUMBERTYPECONDITION("phoneNumberTypeCondition"),
        CALLANALYSISCONDITION("callAnalysisCondition"),
        CONTACTPROPERTYCONDITION("contactPropertyCondition"),
        DATAACTIONCONDITION("dataActionCondition");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

