/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGeolocationRequest;
import com.mypurecloud.sdk.v2.api.request.PatchGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchUserGeolocationRequest;
import com.mypurecloud.sdk.v2.model.Geolocation;
import com.mypurecloud.sdk.v2.model.GeolocationSettings;
import java.util.concurrent.Future;

public class GeolocationApiAsync {
    private final ApiClient pcapiClient;

    public GeolocationApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public GeolocationApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<GeolocationSettings> getGeolocationsSettingsAsync(GetGeolocationsSettingsRequest request, final AsyncApiCallback<GeolocationSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){}, new AsyncApiCallback<ApiResponse<GeolocationSettings>>(){

                @Override
                public void onCompleted(ApiResponse<GeolocationSettings> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        GeolocationApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<GeolocationSettings>> getGeolocationsSettingsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<GeolocationSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<GeolocationSettings>(){}, new AsyncApiCallback<ApiResponse<GeolocationSettings>>(){

                @Override
                public void onCompleted(ApiResponse<GeolocationSettings> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<Geolocation> getUserGeolocationAsync(GetUserGeolocationRequest request, final AsyncApiCallback<Geolocation> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Geolocation>(){}, new AsyncApiCallback<ApiResponse<Geolocation>>(){

                @Override
                public void onCompleted(ApiResponse<Geolocation> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        GeolocationApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Geolocation>> getUserGeolocationAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Geolocation>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Geolocation>(){}, new AsyncApiCallback<ApiResponse<Geolocation>>(){

                @Override
                public void onCompleted(ApiResponse<Geolocation> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<GeolocationSettings> patchGeolocationsSettingsAsync(PatchGeolocationsSettingsRequest request, final AsyncApiCallback<GeolocationSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){}, new AsyncApiCallback<ApiResponse<GeolocationSettings>>(){

                @Override
                public void onCompleted(ApiResponse<GeolocationSettings> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        GeolocationApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<GeolocationSettings>> patchGeolocationsSettingsAsync(ApiRequest<GeolocationSettings> request, final AsyncApiCallback<ApiResponse<GeolocationSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<GeolocationSettings>(){}, new AsyncApiCallback<ApiResponse<GeolocationSettings>>(){

                @Override
                public void onCompleted(ApiResponse<GeolocationSettings> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<Geolocation> patchUserGeolocationAsync(PatchUserGeolocationRequest request, final AsyncApiCallback<Geolocation> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Geolocation>(){}, new AsyncApiCallback<ApiResponse<Geolocation>>(){

                @Override
                public void onCompleted(ApiResponse<Geolocation> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        GeolocationApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Geolocation>> patchUserGeolocationAsync(ApiRequest<Geolocation> request, final AsyncApiCallback<ApiResponse<Geolocation>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Geolocation>(){}, new AsyncApiCallback<ApiResponse<Geolocation>>(){

                @Override
                public void onCompleted(ApiResponse<Geolocation> response) {
                    GeolocationApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        GeolocationApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        GeolocationApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

