/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.SelectedColumns;
import com.mypurecloud.sdk.v2.model.ViewFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReportingExportJobRequest
implements Serializable {
    private String name = null;
    private String timeZone = null;
    private ExportFormatEnum exportFormat = null;
    private String interval = null;
    private String period = null;
    private ViewTypeEnum viewType = null;
    private ViewFilter filter = null;
    private Boolean read = null;
    private String locale = null;
    private Boolean hasFormatDurations = null;
    private Boolean hasSplitFilters = null;
    private Boolean excludeEmptyRows = null;
    private Boolean hasSplitByMedia = null;
    private Boolean hasSummaryRow = null;
    private CsvDelimiterEnum csvDelimiter = null;
    private List<SelectedColumns> selectedColumns = new ArrayList<SelectedColumns>();
    private Boolean hasCustomParticipantAttributes = null;
    private List<String> recipientEmails = new ArrayList<String>();

    public ReportingExportJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user supplied name of the export request")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReportingExportJobRequest timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested timezone of the exported data. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ReportingExportJobRequest exportFormat(ExportFormatEnum exportFormat) {
        this.exportFormat = exportFormat;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested format of the exported data")
    @JsonProperty(value="exportFormat")
    public ExportFormatEnum getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(ExportFormatEnum exportFormat) {
        this.exportFormat = exportFormat;
    }

    public ReportingExportJobRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time period used to limit the the exported data. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ReportingExportJobRequest period(String period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Period of the request in which to break down the intervals. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="period")
    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public ReportingExportJobRequest viewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of view export job to be created")
    @JsonProperty(value="viewType")
    public ViewTypeEnum getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
    }

    public ReportingExportJobRequest filter(ViewFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filters to apply to create the view")
    @JsonProperty(value="filter")
    public ViewFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ViewFilter filter) {
        this.filter = filter;
    }

    public ReportingExportJobRequest read(Boolean read) {
        this.read = read;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the request has been marked as read")
    @JsonProperty(value="read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public ReportingExportJobRequest locale(String locale) {
        this.locale = locale;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The locale use for localization of the exported data, i.e. en-us, es-mx  ")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public ReportingExportJobRequest hasFormatDurations(Boolean hasFormatDurations) {
        this.hasFormatDurations = hasFormatDurations;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if durations are formatted in hh:mm:ss format instead of ms")
    @JsonProperty(value="hasFormatDurations")
    public Boolean getHasFormatDurations() {
        return this.hasFormatDurations;
    }

    public void setHasFormatDurations(Boolean hasFormatDurations) {
        this.hasFormatDurations = hasFormatDurations;
    }

    public ReportingExportJobRequest hasSplitFilters(Boolean hasSplitFilters) {
        this.hasSplitFilters = hasSplitFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if filters will be split in aggregate detail exports")
    @JsonProperty(value="hasSplitFilters")
    public Boolean getHasSplitFilters() {
        return this.hasSplitFilters;
    }

    public void setHasSplitFilters(Boolean hasSplitFilters) {
        this.hasSplitFilters = hasSplitFilters;
    }

    public ReportingExportJobRequest excludeEmptyRows(Boolean excludeEmptyRows) {
        this.excludeEmptyRows = excludeEmptyRows;
        return this;
    }

    @ApiModelProperty(example="null", value="Excludes empty rows from the exports")
    @JsonProperty(value="excludeEmptyRows")
    public Boolean getExcludeEmptyRows() {
        return this.excludeEmptyRows;
    }

    public void setExcludeEmptyRows(Boolean excludeEmptyRows) {
        this.excludeEmptyRows = excludeEmptyRows;
    }

    public ReportingExportJobRequest hasSplitByMedia(Boolean hasSplitByMedia) {
        this.hasSplitByMedia = hasSplitByMedia;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if media type will be split in aggregate detail exports")
    @JsonProperty(value="hasSplitByMedia")
    public Boolean getHasSplitByMedia() {
        return this.hasSplitByMedia;
    }

    public void setHasSplitByMedia(Boolean hasSplitByMedia) {
        this.hasSplitByMedia = hasSplitByMedia;
    }

    public ReportingExportJobRequest hasSummaryRow(Boolean hasSummaryRow) {
        this.hasSummaryRow = hasSummaryRow;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if summary row needs to be present in exports")
    @JsonProperty(value="hasSummaryRow")
    public Boolean getHasSummaryRow() {
        return this.hasSummaryRow;
    }

    public void setHasSummaryRow(Boolean hasSummaryRow) {
        this.hasSummaryRow = hasSummaryRow;
    }

    public ReportingExportJobRequest csvDelimiter(CsvDelimiterEnum csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
        return this;
    }

    @ApiModelProperty(example="null", value="The user supplied csv delimiter string value either of type 'comma' or 'semicolon' permitted for the export request")
    @JsonProperty(value="csvDelimiter")
    public CsvDelimiterEnum getCsvDelimiter() {
        return this.csvDelimiter;
    }

    public void setCsvDelimiter(CsvDelimiterEnum csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
    }

    public ReportingExportJobRequest selectedColumns(List<SelectedColumns> selectedColumns) {
        this.selectedColumns = selectedColumns;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of ordered selected columns from the export view by the user")
    @JsonProperty(value="selectedColumns")
    public List<SelectedColumns> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setSelectedColumns(List<SelectedColumns> selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public ReportingExportJobRequest hasCustomParticipantAttributes(Boolean hasCustomParticipantAttributes) {
        this.hasCustomParticipantAttributes = hasCustomParticipantAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if custom participant attributes will be exported")
    @JsonProperty(value="hasCustomParticipantAttributes")
    public Boolean getHasCustomParticipantAttributes() {
        return this.hasCustomParticipantAttributes;
    }

    public void setHasCustomParticipantAttributes(Boolean hasCustomParticipantAttributes) {
        this.hasCustomParticipantAttributes = hasCustomParticipantAttributes;
    }

    public ReportingExportJobRequest recipientEmails(List<String> recipientEmails) {
        this.recipientEmails = recipientEmails;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of email recipients for the exports")
    @JsonProperty(value="recipientEmails")
    public List<String> getRecipientEmails() {
        return this.recipientEmails;
    }

    public void setRecipientEmails(List<String> recipientEmails) {
        this.recipientEmails = recipientEmails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingExportJobRequest reportingExportJobRequest = (ReportingExportJobRequest)o;
        return Objects.equals(this.name, reportingExportJobRequest.name) && Objects.equals(this.timeZone, reportingExportJobRequest.timeZone) && Objects.equals((Object)this.exportFormat, (Object)reportingExportJobRequest.exportFormat) && Objects.equals(this.interval, reportingExportJobRequest.interval) && Objects.equals(this.period, reportingExportJobRequest.period) && Objects.equals((Object)this.viewType, (Object)reportingExportJobRequest.viewType) && Objects.equals(this.filter, reportingExportJobRequest.filter) && Objects.equals(this.read, reportingExportJobRequest.read) && Objects.equals(this.locale, reportingExportJobRequest.locale) && Objects.equals(this.hasFormatDurations, reportingExportJobRequest.hasFormatDurations) && Objects.equals(this.hasSplitFilters, reportingExportJobRequest.hasSplitFilters) && Objects.equals(this.excludeEmptyRows, reportingExportJobRequest.excludeEmptyRows) && Objects.equals(this.hasSplitByMedia, reportingExportJobRequest.hasSplitByMedia) && Objects.equals(this.hasSummaryRow, reportingExportJobRequest.hasSummaryRow) && Objects.equals((Object)this.csvDelimiter, (Object)reportingExportJobRequest.csvDelimiter) && Objects.equals(this.selectedColumns, reportingExportJobRequest.selectedColumns) && Objects.equals(this.hasCustomParticipantAttributes, reportingExportJobRequest.hasCustomParticipantAttributes) && Objects.equals(this.recipientEmails, reportingExportJobRequest.recipientEmails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.timeZone, this.exportFormat, this.interval, this.period, this.viewType, this.filter, this.read, this.locale, this.hasFormatDurations, this.hasSplitFilters, this.excludeEmptyRows, this.hasSplitByMedia, this.hasSummaryRow, this.csvDelimiter, this.selectedColumns, this.hasCustomParticipantAttributes, this.recipientEmails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportingExportJobRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    exportFormat: ").append(this.toIndentedString((Object)this.exportFormat)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    viewType: ").append(this.toIndentedString((Object)this.viewType)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    hasFormatDurations: ").append(this.toIndentedString(this.hasFormatDurations)).append("\n");
        sb.append("    hasSplitFilters: ").append(this.toIndentedString(this.hasSplitFilters)).append("\n");
        sb.append("    excludeEmptyRows: ").append(this.toIndentedString(this.excludeEmptyRows)).append("\n");
        sb.append("    hasSplitByMedia: ").append(this.toIndentedString(this.hasSplitByMedia)).append("\n");
        sb.append("    hasSummaryRow: ").append(this.toIndentedString(this.hasSummaryRow)).append("\n");
        sb.append("    csvDelimiter: ").append(this.toIndentedString((Object)this.csvDelimiter)).append("\n");
        sb.append("    selectedColumns: ").append(this.toIndentedString(this.selectedColumns)).append("\n");
        sb.append("    hasCustomParticipantAttributes: ").append(this.toIndentedString(this.hasCustomParticipantAttributes)).append("\n");
        sb.append("    recipientEmails: ").append(this.toIndentedString(this.recipientEmails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CsvDelimiterEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SEMICOLON("SEMICOLON"),
        COMMA("COMMA");

        private String value;

        private CsvDelimiterEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CsvDelimiterEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CsvDelimiterEnum value : CsvDelimiterEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CsvDelimiterEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ViewTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUE_PERFORMANCE_SUMMARY_VIEW("QUEUE_PERFORMANCE_SUMMARY_VIEW"),
        QUEUE_PERFORMANCE_DETAIL_VIEW("QUEUE_PERFORMANCE_DETAIL_VIEW"),
        INTERACTION_SEARCH_VIEW("INTERACTION_SEARCH_VIEW"),
        AGENT_PERFORMANCE_SUMMARY_VIEW("AGENT_PERFORMANCE_SUMMARY_VIEW"),
        AGENT_PERFORMANCE_DETAIL_VIEW("AGENT_PERFORMANCE_DETAIL_VIEW"),
        AGENT_STATUS_SUMMARY_VIEW("AGENT_STATUS_SUMMARY_VIEW"),
        AGENT_STATUS_DETAIL_VIEW("AGENT_STATUS_DETAIL_VIEW"),
        AGENT_EVALUATION_SUMMARY_VIEW("AGENT_EVALUATION_SUMMARY_VIEW"),
        AGENT_EVALUATION_DETAIL_VIEW("AGENT_EVALUATION_DETAIL_VIEW"),
        AGENT_QUEUE_DETAIL_VIEW("AGENT_QUEUE_DETAIL_VIEW"),
        AGENT_INTERACTION_DETAIL_VIEW("AGENT_INTERACTION_DETAIL_VIEW"),
        ABANDON_INSIGHTS_VIEW("ABANDON_INSIGHTS_VIEW"),
        SKILLS_PERFORMANCE_VIEW("SKILLS_PERFORMANCE_VIEW"),
        SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW("SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW"),
        SURVEY_FORM_PERFORMANCE_DETAIL_VIEW("SURVEY_FORM_PERFORMANCE_DETAIL_VIEW"),
        DNIS_PERFORMANCE_SUMMARY_VIEW("DNIS_PERFORMANCE_SUMMARY_VIEW"),
        DNIS_PERFORMANCE_DETAIL_VIEW("DNIS_PERFORMANCE_DETAIL_VIEW"),
        WRAP_UP_PERFORMANCE_SUMMARY_VIEW("WRAP_UP_PERFORMANCE_SUMMARY_VIEW"),
        AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW("AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW"),
        QUEUE_ACTIVITY_SUMMARY_VIEW("QUEUE_ACTIVITY_SUMMARY_VIEW"),
        QUEUE_ACTIVITY_DETAIL_VIEW("QUEUE_ACTIVITY_DETAIL_VIEW"),
        AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW("AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW"),
        QUEUE_AGENT_DETAIL_VIEW("QUEUE_AGENT_DETAIL_VIEW"),
        QUEUE_INTERACTION_DETAIL_VIEW("QUEUE_INTERACTION_DETAIL_VIEW"),
        AGENT_SCHEDULE_DETAIL_VIEW("AGENT_SCHEDULE_DETAIL_VIEW"),
        IVR_PERFORMANCE_SUMMARY_VIEW("IVR_PERFORMANCE_SUMMARY_VIEW"),
        IVR_PERFORMANCE_DETAIL_VIEW("IVR_PERFORMANCE_DETAIL_VIEW"),
        ANSWER_INSIGHTS_VIEW("ANSWER_INSIGHTS_VIEW"),
        HANDLE_INSIGHTS_VIEW("HANDLE_INSIGHTS_VIEW"),
        TALK_INSIGHTS_VIEW("TALK_INSIGHTS_VIEW"),
        HOLD_INSIGHTS_VIEW("HOLD_INSIGHTS_VIEW"),
        ACW_INSIGHTS_VIEW("ACW_INSIGHTS_VIEW"),
        WAIT_INSIGHTS_VIEW("WAIT_INSIGHTS_VIEW"),
        AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW("AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW"),
        FLOW_OUTCOME_SUMMARY_VIEW("FLOW_OUTCOME_SUMMARY_VIEW"),
        FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW("FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW"),
        FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW("FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW"),
        FLOW_DESTINATION_SUMMARY_VIEW("FLOW_DESTINATION_SUMMARY_VIEW"),
        FLOW_DESTINATION_DETAIL_VIEW("FLOW_DESTINATION_DETAIL_VIEW"),
        API_USAGE_VIEW("API_USAGE_VIEW"),
        SCHEDULED_CALLBACKS_VIEW("SCHEDULED_CALLBACKS_VIEW"),
        CONTENT_SEARCH_VIEW("CONTENT_SEARCH_VIEW"),
        LANDING_PAGE("LANDING_PAGE"),
        DASHBOARD_SUMMARY("DASHBOARD_SUMMARY"),
        DASHBOARD_DETAIL("DASHBOARD_DETAIL");

        private String value;

        private ViewTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ViewTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ViewTypeEnum value : ViewTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ViewTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ExportFormatEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CSV("CSV"),
        PDF("PDF");

        private String value;

        private ExportFormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExportFormatEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExportFormatEnum value : ExportFormatEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExportFormatEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

