/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.ManagementUnitSettingsResponse;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Management Unit object for Workforce Management")
public class ManagementUnit
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private StartDayOfWeekEnum startDayOfWeek = null;
    private String timeZone = null;
    private ManagementUnitSettingsResponse settings = null;
    private WfmVersionedEntityMetadata metadata = null;
    private Integer version = null;
    private Date dateModified = null;
    private UserReference modifiedBy = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ManagementUnit name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ManagementUnit division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public ManagementUnit startDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="Start day of week for scheduling and forecasting purposes. Moving to Business Unit")
    @JsonProperty(value="startDayOfWeek")
    public StartDayOfWeekEnum getStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public void setStartDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
    }

    public ManagementUnit timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The time zone for the management unit in standard Olson format.  Moving to Business Unit")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ManagementUnit settings(ManagementUnitSettingsResponse settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration settings for this management unit")
    @JsonProperty(value="settings")
    public ManagementUnitSettingsResponse getSettings() {
        return this.settings;
    }

    public void setSettings(ManagementUnitSettingsResponse settings) {
        this.settings = settings;
    }

    public ManagementUnit metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version info metadata for this management unit. Deprecated, use settings.metadata")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The version of the underlying entity.  Deprecated, use field from settings.metadata instead")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="The date and time at which this entity was last modified.  Deprecated, use field from settings.metadata instead. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public ManagementUnit modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who last modified this entity.  Deprecated, use field from settings.metadata instead")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementUnit managementUnit = (ManagementUnit)o;
        return Objects.equals(this.id, managementUnit.id) && Objects.equals(this.name, managementUnit.name) && Objects.equals(this.division, managementUnit.division) && Objects.equals((Object)this.startDayOfWeek, (Object)managementUnit.startDayOfWeek) && Objects.equals(this.timeZone, managementUnit.timeZone) && Objects.equals(this.settings, managementUnit.settings) && Objects.equals(this.metadata, managementUnit.metadata) && Objects.equals(this.version, managementUnit.version) && Objects.equals(this.dateModified, managementUnit.dateModified) && Objects.equals(this.modifiedBy, managementUnit.modifiedBy) && Objects.equals(this.selfUri, managementUnit.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.startDayOfWeek, this.timeZone, this.settings, this.metadata, this.version, this.dateModified, this.modifiedBy, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagementUnit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    startDayOfWeek: ").append(this.toIndentedString((Object)this.startDayOfWeek)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StartDayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private StartDayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StartDayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StartDayOfWeekEnum value : StartDayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StartDayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

