/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ConversationDivisionMembership;
import com.mypurecloud.sdk.v2.model.Participant;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Conversation
implements Serializable {
    private String id = null;
    private String name = null;
    private Date startTime = null;
    private Date endTime = null;
    private String address = null;
    private List<Participant> participants = new ArrayList<Participant>();
    private List<String> conversationIds = new ArrayList<String>();
    private Integer maxParticipants = null;
    private RecordingStateEnum recordingState = null;
    private StateEnum state = null;
    private List<ConversationDivisionMembership> divisions = new ArrayList<ConversationDivisionMembership>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Conversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Conversation startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time when the conversation started. This will be the time when the first participant joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Conversation endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the conversation ended. This will be the time when the last participant left the conversation, or null when the conversation is still active. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Conversation address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The address of the conversation as seen from an external participant. For phone calls this will be the DNIS for inbound calls and the ANI for outbound calls. For other media types this will be the address of the destination participant for inbound and the address of the initiating participant for outbound.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Conversation participants(List<Participant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of all participants in the conversation.")
    @JsonProperty(value="participants")
    public List<Participant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<Participant> participants) {
        this.participants = participants;
    }

    public Conversation conversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of conversations to merge into this conversation to create a conference. This field is null except when being used to create a conference.")
    @JsonProperty(value="conversationIds")
    public List<String> getConversationIds() {
        return this.conversationIds;
    }

    public void setConversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
    }

    public Conversation maxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    @ApiModelProperty(example="null", value="If this is a conference conversation, then this field indicates the maximum number of participants allowed to participant in the conference.")
    @JsonProperty(value="maxParticipants")
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    public Conversation recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="On update, 'paused' initiates a secure pause, 'active' resumes any paused recordings; otherwise indicates state of conversation recording.")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public Conversation state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The conversation's state")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Conversation divisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of divisions associated with this conversation")
    @JsonProperty(value="divisions")
    public List<ConversationDivisionMembership> getDivisions() {
        return this.divisions;
    }

    public void setDivisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation conversation = (Conversation)o;
        return Objects.equals(this.id, conversation.id) && Objects.equals(this.name, conversation.name) && Objects.equals(this.startTime, conversation.startTime) && Objects.equals(this.endTime, conversation.endTime) && Objects.equals(this.address, conversation.address) && Objects.equals(this.participants, conversation.participants) && Objects.equals(this.conversationIds, conversation.conversationIds) && Objects.equals(this.maxParticipants, conversation.maxParticipants) && Objects.equals((Object)this.recordingState, (Object)conversation.recordingState) && Objects.equals((Object)this.state, (Object)conversation.state) && Objects.equals(this.divisions, conversation.divisions) && Objects.equals(this.selfUri, conversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.startTime, this.endTime, this.address, this.participants, this.conversationIds, this.maxParticipants, this.recordingState, this.state, this.divisions, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Conversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    conversationIds: ").append(this.toIndentedString(this.conversationIds)).append("\n");
        sb.append("    maxParticipants: ").append(this.toIndentedString(this.maxParticipants)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    divisions: ").append(this.toIndentedString(this.divisions)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("ACTIVE"),
        PAUSED("PAUSED"),
        NONE("NONE");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

