/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.PresenceDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.RoutingStatusDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.UserDetailQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AsyncUserDetailsQuery
implements Serializable {
    private String interval = null;
    private List<UserDetailQueryFilter> userFilters = new ArrayList<UserDetailQueryFilter>();
    private List<PresenceDetailQueryFilter> presenceFilters = new ArrayList<PresenceDetailQueryFilter>();
    private List<RoutingStatusDetailQueryFilter> routingStatusFilters = new ArrayList<RoutingStatusDetailQueryFilter>();
    private OrderEnum order = null;
    private Integer limit = null;

    public AsyncUserDetailsQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the date and time range of data being queried. Conversations MUST have started within this time range to potentially be included within the result set. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AsyncUserDetailsQuery userFilters(List<UserDetailQueryFilter> userFilters) {
        this.userFilters = userFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target the users to retrieve data for")
    @JsonProperty(value="userFilters")
    public List<UserDetailQueryFilter> getUserFilters() {
        return this.userFilters;
    }

    public void setUserFilters(List<UserDetailQueryFilter> userFilters) {
        this.userFilters = userFilters;
    }

    public AsyncUserDetailsQuery presenceFilters(List<PresenceDetailQueryFilter> presenceFilters) {
        this.presenceFilters = presenceFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target system and organization presence-level data")
    @JsonProperty(value="presenceFilters")
    public List<PresenceDetailQueryFilter> getPresenceFilters() {
        return this.presenceFilters;
    }

    public void setPresenceFilters(List<PresenceDetailQueryFilter> presenceFilters) {
        this.presenceFilters = presenceFilters;
    }

    public AsyncUserDetailsQuery routingStatusFilters(List<RoutingStatusDetailQueryFilter> routingStatusFilters) {
        this.routingStatusFilters = routingStatusFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target agent routing status-level data")
    @JsonProperty(value="routingStatusFilters")
    public List<RoutingStatusDetailQueryFilter> getRoutingStatusFilters() {
        return this.routingStatusFilters;
    }

    public void setRoutingStatusFilters(List<RoutingStatusDetailQueryFilter> routingStatusFilters) {
        this.routingStatusFilters = routingStatusFilters;
    }

    public AsyncUserDetailsQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort the result set in ascending/descending order. Default is ascending")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public AsyncUserDetailsQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify number of results to be returned")
    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncUserDetailsQuery asyncUserDetailsQuery = (AsyncUserDetailsQuery)o;
        return Objects.equals(this.interval, asyncUserDetailsQuery.interval) && Objects.equals(this.userFilters, asyncUserDetailsQuery.userFilters) && Objects.equals(this.presenceFilters, asyncUserDetailsQuery.presenceFilters) && Objects.equals(this.routingStatusFilters, asyncUserDetailsQuery.routingStatusFilters) && Objects.equals((Object)this.order, (Object)asyncUserDetailsQuery.order) && Objects.equals(this.limit, asyncUserDetailsQuery.limit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.userFilters, this.presenceFilters, this.routingStatusFilters, this.order, this.limit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AsyncUserDetailsQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    userFilters: ").append(this.toIndentedString(this.userFilters)).append("\n");
        sb.append("    presenceFilters: ").append(this.toIndentedString(this.presenceFilters)).append("\n");
        sb.append("    routingStatusFilters: ").append(this.toIndentedString(this.routingStatusFilters)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

