/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Greeting;
import java.util.HashMap;
import java.util.Map;

public class PostGroupGreetingsRequest {
    private String groupId;
    private Greeting body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PostGroupGreetingsRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public Greeting getBody() {
        return this.body;
    }

    public void setBody(Greeting body) {
        this.body = body;
    }

    public PostGroupGreetingsRequest withBody(Greeting body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostGroupGreetingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Greeting> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PostGroupGreetingsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostGroupGreetingsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/groups/{groupId}/greetings").withPathParameter("groupId", this.groupId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, Greeting body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PostGroupGreetingsRequest request = new PostGroupGreetingsRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(Greeting body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String groupId, Greeting body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PostGroupGreetingsRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PostGroupGreetingsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostGroupGreetingsRequest.");
            }
            return this.request;
        }
    }
}

