/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.FlowVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details about the current state of a Flow execution")
public class FlowRuntimeExecution
implements Serializable {
    private String id = null;
    private String name = null;
    private FlowVersion flowVersion = null;
    private Date dateLaunched = null;
    private StatusEnum status = null;
    private Date dateCompleted = null;
    private String completionReason = null;
    private ErrorBody flowErrorInfo = null;
    private Map<String, Object> outputData = null;
    private DomainEntityRef conversation = null;
    private String selfUri = null;

    public FlowRuntimeExecution id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow execution ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FlowRuntimeExecution name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow execution name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowRuntimeExecution flowVersion(FlowVersion flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Version of the flow definition of the flow execution.")
    @JsonProperty(value="flowVersion")
    public FlowVersion getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(FlowVersion flowVersion) {
        this.flowVersion = flowVersion;
    }

    public FlowRuntimeExecution dateLaunched(Date dateLaunched) {
        this.dateLaunched = dateLaunched;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLaunched")
    public Date getDateLaunched() {
        return this.dateLaunched;
    }

    public void setDateLaunched(Date dateLaunched) {
        this.dateLaunched = dateLaunched;
    }

    public FlowRuntimeExecution status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The flow's running status, which indicates whether the flow is running normally or completed, etc.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FlowRuntimeExecution dateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @ApiModelProperty(example="null", value="The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public FlowRuntimeExecution completionReason(String completionReason) {
        this.completionReason = completionReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The completion reason set at the flow completion time, if applicable.")
    @JsonProperty(value="completionReason")
    public String getCompletionReason() {
        return this.completionReason;
    }

    public void setCompletionReason(String completionReason) {
        this.completionReason = completionReason;
    }

    public FlowRuntimeExecution flowErrorInfo(ErrorBody flowErrorInfo) {
        this.flowErrorInfo = flowErrorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional information if the flow is in error")
    @JsonProperty(value="flowErrorInfo")
    public ErrorBody getFlowErrorInfo() {
        return this.flowErrorInfo;
    }

    public void setFlowErrorInfo(ErrorBody flowErrorInfo) {
        this.flowErrorInfo = flowErrorInfo;
    }

    public FlowRuntimeExecution outputData(Map<String, Object> outputData) {
        this.outputData = outputData;
        return this;
    }

    @ApiModelProperty(example="null", value="List of the flow's output variables, if any. Output variables are only supplied for Completed flows.")
    @JsonProperty(value="outputData")
    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public FlowRuntimeExecution conversation(DomainEntityRef conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="The conversation to which this Flow execution is related")
    @JsonProperty(value="conversation")
    public DomainEntityRef getConversation() {
        return this.conversation;
    }

    public void setConversation(DomainEntityRef conversation) {
        this.conversation = conversation;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowRuntimeExecution flowRuntimeExecution = (FlowRuntimeExecution)o;
        return Objects.equals(this.id, flowRuntimeExecution.id) && Objects.equals(this.name, flowRuntimeExecution.name) && Objects.equals(this.flowVersion, flowRuntimeExecution.flowVersion) && Objects.equals(this.dateLaunched, flowRuntimeExecution.dateLaunched) && Objects.equals((Object)this.status, (Object)flowRuntimeExecution.status) && Objects.equals(this.dateCompleted, flowRuntimeExecution.dateCompleted) && Objects.equals(this.completionReason, flowRuntimeExecution.completionReason) && Objects.equals(this.flowErrorInfo, flowRuntimeExecution.flowErrorInfo) && Objects.equals(this.outputData, flowRuntimeExecution.outputData) && Objects.equals(this.conversation, flowRuntimeExecution.conversation) && Objects.equals(this.selfUri, flowRuntimeExecution.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.flowVersion, this.dateLaunched, this.status, this.dateCompleted, this.completionReason, this.flowErrorInfo, this.outputData, this.conversation, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowRuntimeExecution {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString(this.flowVersion)).append("\n");
        sb.append("    dateLaunched: ").append(this.toIndentedString(this.dateLaunched)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    completionReason: ").append(this.toIndentedString(this.completionReason)).append("\n");
        sb.append("    flowErrorInfo: ").append(this.toIndentedString(this.flowErrorInfo)).append("\n");
        sb.append("    outputData: ").append(this.toIndentedString(this.outputData)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("UNKNOWN"),
        RUNNING("RUNNING"),
        ERROR("ERROR"),
        TERMINATED("TERMINATED"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

