/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ContentActions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Structured template button object")
public class ButtonComponent
implements Serializable {
    private String id = null;
    private String text = null;
    private String title = null;
    private ContentActions actions = null;

    public ButtonComponent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to this component")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ButtonComponent text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show inside the button")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ButtonComponent title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Tooltip text to show when hovering over the button")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ButtonComponent actions(ContentActions actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", value="User actions available on the content. All actions are optional and all actions are executed simultaneously.")
    @JsonProperty(value="actions")
    public ContentActions getActions() {
        return this.actions;
    }

    public void setActions(ContentActions actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ButtonComponent buttonComponent = (ButtonComponent)o;
        return Objects.equals(this.id, buttonComponent.id) && Objects.equals(this.text, buttonComponent.text) && Objects.equals(this.title, buttonComponent.title) && Objects.equals(this.actions, buttonComponent.actions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.title, this.actions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ButtonComponent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

