/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetOauthClientUsageQueryResultRequest {
    private String executionId;
    private String clientId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public GetOauthClientUsageQueryResultRequest withExecutionId(String executionId) {
        this.setExecutionId(executionId);
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GetOauthClientUsageQueryResultRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOauthClientUsageQueryResultRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.executionId == null) {
            throw new IllegalStateException("Missing the required parameter 'executionId' when building request for GetOauthClientUsageQueryResultRequest.");
        }
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for GetOauthClientUsageQueryResultRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/oauth/clients/{clientId}/usage/query/results/{executionId}").withPathParameter("executionId", this.executionId).withPathParameter("clientId", this.clientId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String executionId, String clientId) {
        return new Builder().withRequiredParams(executionId, clientId);
    }

    public static class Builder {
        private final GetOauthClientUsageQueryResultRequest request = new GetOauthClientUsageQueryResultRequest();

        private Builder() {
        }

        public Builder withExecutionId(String executionId) {
            this.request.setExecutionId(executionId);
            return this;
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withRequiredParams(String executionId, String clientId) {
            this.request.setExecutionId(executionId);
            this.request.setClientId(clientId);
            return this;
        }

        public GetOauthClientUsageQueryResultRequest build() {
            if (this.request.executionId == null) {
                throw new IllegalStateException("Missing the required parameter 'executionId' when building request for GetOauthClientUsageQueryResultRequest.");
            }
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for GetOauthClientUsageQueryResultRequest.");
            }
            return this.request;
        }
    }
}

