/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Endpoint;
import com.mypurecloud.sdk.v2.model.Recording;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class OrphanRecording
implements Serializable {
    private String id = null;
    private String name = null;
    private Date createdTime = null;
    private Date recoveredTime = null;
    private ProviderTypeEnum providerType = null;
    private Long mediaSizeBytes = null;
    private MediaTypeEnum mediaType = null;
    private FileStateEnum fileState = null;
    private Endpoint providerEndpoint = null;
    private Recording recording = null;
    private OrphanStatusEnum orphanStatus = null;
    private String sourceOrphaningId = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OrphanRecording name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrphanRecording createdTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="createdTime")
    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public OrphanRecording recoveredTime(Date recoveredTime) {
        this.recoveredTime = recoveredTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="recoveredTime")
    public Date getRecoveredTime() {
        return this.recoveredTime;
    }

    public void setRecoveredTime(Date recoveredTime) {
        this.recoveredTime = recoveredTime;
    }

    public OrphanRecording providerType(ProviderTypeEnum providerType) {
        this.providerType = providerType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="providerType")
    public ProviderTypeEnum getProviderType() {
        return this.providerType;
    }

    public void setProviderType(ProviderTypeEnum providerType) {
        this.providerType = providerType;
    }

    public OrphanRecording mediaSizeBytes(Long mediaSizeBytes) {
        this.mediaSizeBytes = mediaSizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="mediaSizeBytes")
    public Long getMediaSizeBytes() {
        return this.mediaSizeBytes;
    }

    public void setMediaSizeBytes(Long mediaSizeBytes) {
        this.mediaSizeBytes = mediaSizeBytes;
    }

    public OrphanRecording mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public OrphanRecording fileState(FileStateEnum fileState) {
        this.fileState = fileState;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="fileState")
    public FileStateEnum getFileState() {
        return this.fileState;
    }

    public void setFileState(FileStateEnum fileState) {
        this.fileState = fileState;
    }

    public OrphanRecording providerEndpoint(Endpoint providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="providerEndpoint")
    public Endpoint getProviderEndpoint() {
        return this.providerEndpoint;
    }

    public void setProviderEndpoint(Endpoint providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    public OrphanRecording recording(Recording recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="recording")
    public Recording getRecording() {
        return this.recording;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public OrphanRecording orphanStatus(OrphanStatusEnum orphanStatus) {
        this.orphanStatus = orphanStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the orphaned recording's conversation.")
    @JsonProperty(value="orphanStatus")
    public OrphanStatusEnum getOrphanStatus() {
        return this.orphanStatus;
    }

    public void setOrphanStatus(OrphanStatusEnum orphanStatus) {
        this.orphanStatus = orphanStatus;
    }

    public OrphanRecording sourceOrphaningId(String sourceOrphaningId) {
        this.sourceOrphaningId = sourceOrphaningId;
        return this;
    }

    @ApiModelProperty(example="null", value="An identifier used during recovery operations by the supplying hybrid platform to track back and determine which interaction this recording is associated with")
    @JsonProperty(value="sourceOrphaningId")
    public String getSourceOrphaningId() {
        return this.sourceOrphaningId;
    }

    public void setSourceOrphaningId(String sourceOrphaningId) {
        this.sourceOrphaningId = sourceOrphaningId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrphanRecording orphanRecording = (OrphanRecording)o;
        return Objects.equals(this.id, orphanRecording.id) && Objects.equals(this.name, orphanRecording.name) && Objects.equals(this.createdTime, orphanRecording.createdTime) && Objects.equals(this.recoveredTime, orphanRecording.recoveredTime) && Objects.equals((Object)this.providerType, (Object)orphanRecording.providerType) && Objects.equals(this.mediaSizeBytes, orphanRecording.mediaSizeBytes) && Objects.equals((Object)this.mediaType, (Object)orphanRecording.mediaType) && Objects.equals((Object)this.fileState, (Object)orphanRecording.fileState) && Objects.equals(this.providerEndpoint, orphanRecording.providerEndpoint) && Objects.equals(this.recording, orphanRecording.recording) && Objects.equals((Object)this.orphanStatus, (Object)orphanRecording.orphanStatus) && Objects.equals(this.sourceOrphaningId, orphanRecording.sourceOrphaningId) && Objects.equals(this.selfUri, orphanRecording.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.createdTime, this.recoveredTime, this.providerType, this.mediaSizeBytes, this.mediaType, this.fileState, this.providerEndpoint, this.recording, this.orphanStatus, this.sourceOrphaningId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrphanRecording {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    recoveredTime: ").append(this.toIndentedString(this.recoveredTime)).append("\n");
        sb.append("    providerType: ").append(this.toIndentedString((Object)this.providerType)).append("\n");
        sb.append("    mediaSizeBytes: ").append(this.toIndentedString(this.mediaSizeBytes)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    fileState: ").append(this.toIndentedString((Object)this.fileState)).append("\n");
        sb.append("    providerEndpoint: ").append(this.toIndentedString(this.providerEndpoint)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    orphanStatus: ").append(this.toIndentedString((Object)this.orphanStatus)).append("\n");
        sb.append("    sourceOrphaningId: ").append(this.toIndentedString(this.sourceOrphaningId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrphanStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NO_CONVERSATION("NO_CONVERSATION"),
        UNKNOWN_CONVERSATION("UNKNOWN_CONVERSATION"),
        CONVERSATION_NOT_COMPLETE("CONVERSATION_NOT_COMPLETE"),
        CONVERSATION_NOT_EVALUATED("CONVERSATION_NOT_EVALUATED"),
        EVALUATED("EVALUATED");

        private String value;

        private OrphanStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrphanStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrphanStatusEnum value : OrphanStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrphanStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FileStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ARCHIVED("ARCHIVED"),
        AVAILABLE("AVAILABLE"),
        DELETED("DELETED"),
        RESTORED("RESTORED"),
        RESTORING("RESTORING"),
        UPLOADING("UPLOADING");

        private String value;

        private FileStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileStateEnum value : FileStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("CALL"),
        CHAT("CHAT"),
        EMAIL("EMAIL"),
        SCREEN("SCREEN");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ProviderTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EDGE("EDGE"),
        CHAT("CHAT"),
        EMAIL("EMAIL"),
        SCREEN_RECORDING("SCREEN_RECORDING");

        private String value;

        private ProviderTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProviderTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ProviderTypeEnum value : ProviderTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ProviderTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

