/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.RoleDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class OAuthClientRequest
implements Serializable {
    private String name = null;
    private Long accessTokenValiditySeconds = null;
    private String description = null;
    private List<String> registeredRedirectUri = new ArrayList<String>();
    private List<String> roleIds = new ArrayList<String>();
    private AuthorizedGrantTypeEnum authorizedGrantType = null;
    private List<String> scope = new ArrayList<String>();
    private List<RoleDivision> roleDivisions = new ArrayList<RoleDivision>();
    private StateEnum state = null;
    private Date dateToDelete = null;

    public OAuthClientRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the OAuth client.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OAuthClientRequest accessTokenValiditySeconds(Long accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.")
    @JsonProperty(value="accessTokenValiditySeconds")
    public Long getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Long accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public OAuthClientRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OAuthClientRequest registeredRedirectUri(List<String> registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
        return this;
    }

    @ApiModelProperty(example="null", value="List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback")
    @JsonProperty(value="registeredRedirectUri")
    public List<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUri;
    }

    public void setRegisteredRedirectUri(List<String> registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
    }

    public OAuthClientRequest roleIds(List<String> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Deprecated. Use roleDivisions instead.")
    @JsonProperty(value="roleIds")
    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public OAuthClientRequest authorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. ")
    @JsonProperty(value="authorizedGrantType")
    public AuthorizedGrantTypeEnum getAuthorizedGrantType() {
        return this.authorizedGrantType;
    }

    public void setAuthorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
    }

    public OAuthClientRequest scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", value="The scope requested by this client. Scopes only apply to clients not using the client_credential grant")
    @JsonProperty(value="scope")
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public OAuthClientRequest roleDivisions(List<RoleDivision> roleDivisions) {
        this.roleDivisions = roleDivisions;
        return this;
    }

    @ApiModelProperty(example="null", value="Set of roles and their corresponding divisions associated with this client. Roles and divisions only apply to clients using the client_credential grant")
    @JsonProperty(value="roleDivisions")
    public List<RoleDivision> getRoleDivisions() {
        return this.roleDivisions;
    }

    public void setRoleDivisions(List<RoleDivision> roleDivisions) {
        this.roleDivisions = roleDivisions;
    }

    public OAuthClientRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the OAuth client. Active: The OAuth client can be used to create access tokens. This is the default state. Disabled: Access tokens created by the client are invalid and new ones cannot be created. Inactive: Access tokens cannot be created with this OAuth client and it will be deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OAuthClientRequest dateToDelete(Date dateToDelete) {
        this.dateToDelete = dateToDelete;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which this client will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateToDelete")
    public Date getDateToDelete() {
        return this.dateToDelete;
    }

    public void setDateToDelete(Date dateToDelete) {
        this.dateToDelete = dateToDelete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientRequest oAuthClientRequest = (OAuthClientRequest)o;
        return Objects.equals(this.name, oAuthClientRequest.name) && Objects.equals(this.accessTokenValiditySeconds, oAuthClientRequest.accessTokenValiditySeconds) && Objects.equals(this.description, oAuthClientRequest.description) && Objects.equals(this.registeredRedirectUri, oAuthClientRequest.registeredRedirectUri) && Objects.equals(this.roleIds, oAuthClientRequest.roleIds) && Objects.equals((Object)this.authorizedGrantType, (Object)oAuthClientRequest.authorizedGrantType) && Objects.equals(this.scope, oAuthClientRequest.scope) && Objects.equals(this.roleDivisions, oAuthClientRequest.roleDivisions) && Objects.equals((Object)this.state, (Object)oAuthClientRequest.state) && Objects.equals(this.dateToDelete, oAuthClientRequest.dateToDelete);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.accessTokenValiditySeconds, this.description, this.registeredRedirectUri, this.roleIds, this.authorizedGrantType, this.scope, this.roleDivisions, this.state, this.dateToDelete});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthClientRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accessTokenValiditySeconds: ").append(this.toIndentedString(this.accessTokenValiditySeconds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    registeredRedirectUri: ").append(this.toIndentedString(this.registeredRedirectUri)).append("\n");
        sb.append("    roleIds: ").append(this.toIndentedString(this.roleIds)).append("\n");
        sb.append("    authorizedGrantType: ").append(this.toIndentedString((Object)this.authorizedGrantType)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    roleDivisions: ").append(this.toIndentedString(this.roleDivisions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateToDelete: ").append(this.toIndentedString(this.dateToDelete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        DISABLED("disabled"),
        INACTIVE("inactive");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AuthorizedGrantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODE("CODE"),
        TOKEN("TOKEN"),
        SAML2BEARER("SAML2BEARER"),
        PASSWORD("PASSWORD"),
        CLIENT_CREDENTIALS("CLIENT_CREDENTIALS");

        private String value;

        private AuthorizedGrantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthorizedGrantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AuthorizedGrantTypeEnum value : AuthorizedGrantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AuthorizedGrantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

