/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Attachment object")
public class ContentAttachment
implements Serializable {
    private String id = null;
    private MediaTypeEnum mediaType = null;
    private String url = null;
    private String mime = null;
    private String text = null;
    private String sha256 = null;
    private String filename = null;

    public ContentAttachment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Vendor specific ID for media. For example, a LINE sticker ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentAttachment mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of media this instance represents")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ContentAttachment url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="Content element url")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ContentAttachment mime(String mime) {
        this.mime = mime;
        return this;
    }

    @ApiModelProperty(example="null", value="Content mime type from https://www.iana.org/assignments/media-types/media-types.xhtml")
    @JsonProperty(value="mime")
    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public ContentAttachment text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text message associated with media element: e.g. caption in case of image.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ContentAttachment sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    @ApiModelProperty(example="null", value="Secure hash of the media content")
    @JsonProperty(value="sha256")
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public ContentAttachment filename(String filename) {
        this.filename = filename;
        return this;
    }

    @ApiModelProperty(example="null", value="Suggested file name for media file")
    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentAttachment contentAttachment = (ContentAttachment)o;
        return Objects.equals(this.id, contentAttachment.id) && Objects.equals((Object)this.mediaType, (Object)contentAttachment.mediaType) && Objects.equals(this.url, contentAttachment.url) && Objects.equals(this.mime, contentAttachment.mime) && Objects.equals(this.text, contentAttachment.text) && Objects.equals(this.sha256, contentAttachment.sha256) && Objects.equals(this.filename, contentAttachment.filename);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mediaType, this.url, this.mime, this.text, this.sha256, this.filename});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentAttachment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mime: ").append(this.toIndentedString(this.mime)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    sha256: ").append(this.toIndentedString(this.sha256)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMAGE("Image"),
        VIDEO("Video"),
        AUDIO("Audio"),
        FILE("File");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

