/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetUsersDevelopmentActivitiesMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersDevelopmentActivitiesRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersDevelopmentActivityRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsersDevelopmentActivitiesAggregatesQueryRequest;
import com.mypurecloud.sdk.v2.model.DevelopmentActivity;
import com.mypurecloud.sdk.v2.model.DevelopmentActivityAggregateParam;
import com.mypurecloud.sdk.v2.model.DevelopmentActivityAggregateResponse;
import com.mypurecloud.sdk.v2.model.DevelopmentActivityListing;
import java.io.IOException;
import java.util.List;

public class UserDevelopmentApi {
    private final ApiClient pcapiClient;

    public UserDevelopmentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserDevelopmentApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public DevelopmentActivityListing getUsersDevelopmentActivities(List<String> userId, String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) throws IOException, ApiException {
        return this.getUsersDevelopmentActivities(this.createGetUsersDevelopmentActivitiesRequest(userId, moduleId, interval, completionInterval, overdue, pageSize, pageNumber, sortOrder, types, statuses, relationship));
    }

    public ApiResponse<DevelopmentActivityListing> getUsersDevelopmentActivitiesWithHttpInfo(List<String> userId, String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) throws IOException {
        return this.getUsersDevelopmentActivities(this.createGetUsersDevelopmentActivitiesRequest(userId, moduleId, interval, completionInterval, overdue, pageSize, pageNumber, sortOrder, types, statuses, relationship).withHttpInfo());
    }

    private GetUsersDevelopmentActivitiesRequest createGetUsersDevelopmentActivitiesRequest(List<String> userId, String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) {
        return GetUsersDevelopmentActivitiesRequest.builder().withUserId(userId).withModuleId(moduleId).withInterval(interval).withCompletionInterval(completionInterval).withOverdue(overdue).withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).withTypes(types).withStatuses(statuses).withRelationship(relationship).build();
    }

    public DevelopmentActivityListing getUsersDevelopmentActivities(GetUsersDevelopmentActivitiesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DevelopmentActivityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DevelopmentActivityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DevelopmentActivityListing> getUsersDevelopmentActivities(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DevelopmentActivityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DevelopmentActivityListing getUsersDevelopmentActivitiesMe(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) throws IOException, ApiException {
        return this.getUsersDevelopmentActivitiesMe(this.createGetUsersDevelopmentActivitiesMeRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, sortOrder, types, statuses, relationship));
    }

    public ApiResponse<DevelopmentActivityListing> getUsersDevelopmentActivitiesMeWithHttpInfo(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) throws IOException {
        return this.getUsersDevelopmentActivitiesMe(this.createGetUsersDevelopmentActivitiesMeRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, sortOrder, types, statuses, relationship).withHttpInfo());
    }

    private GetUsersDevelopmentActivitiesMeRequest createGetUsersDevelopmentActivitiesMeRequest(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String sortOrder, List<String> types, List<String> statuses, List<String> relationship) {
        return GetUsersDevelopmentActivitiesMeRequest.builder().withModuleId(moduleId).withInterval(interval).withCompletionInterval(completionInterval).withOverdue(overdue).withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).withTypes(types).withStatuses(statuses).withRelationship(relationship).build();
    }

    public DevelopmentActivityListing getUsersDevelopmentActivitiesMe(GetUsersDevelopmentActivitiesMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DevelopmentActivityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DevelopmentActivityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DevelopmentActivityListing> getUsersDevelopmentActivitiesMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DevelopmentActivityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DevelopmentActivity getUsersDevelopmentActivity(String activityId, String type) throws IOException, ApiException {
        return this.getUsersDevelopmentActivity(this.createGetUsersDevelopmentActivityRequest(activityId, type));
    }

    public ApiResponse<DevelopmentActivity> getUsersDevelopmentActivityWithHttpInfo(String activityId, String type) throws IOException {
        return this.getUsersDevelopmentActivity(this.createGetUsersDevelopmentActivityRequest(activityId, type).withHttpInfo());
    }

    private GetUsersDevelopmentActivityRequest createGetUsersDevelopmentActivityRequest(String activityId, String type) {
        return GetUsersDevelopmentActivityRequest.builder().withActivityId(activityId).withType(type).build();
    }

    public DevelopmentActivity getUsersDevelopmentActivity(GetUsersDevelopmentActivityRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DevelopmentActivity> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DevelopmentActivity>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DevelopmentActivity> getUsersDevelopmentActivity(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DevelopmentActivity>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DevelopmentActivityAggregateResponse postUsersDevelopmentActivitiesAggregatesQuery(DevelopmentActivityAggregateParam body) throws IOException, ApiException {
        return this.postUsersDevelopmentActivitiesAggregatesQuery(this.createPostUsersDevelopmentActivitiesAggregatesQueryRequest(body));
    }

    public ApiResponse<DevelopmentActivityAggregateResponse> postUsersDevelopmentActivitiesAggregatesQueryWithHttpInfo(DevelopmentActivityAggregateParam body) throws IOException {
        return this.postUsersDevelopmentActivitiesAggregatesQuery(this.createPostUsersDevelopmentActivitiesAggregatesQueryRequest(body).withHttpInfo());
    }

    private PostUsersDevelopmentActivitiesAggregatesQueryRequest createPostUsersDevelopmentActivitiesAggregatesQueryRequest(DevelopmentActivityAggregateParam body) {
        return PostUsersDevelopmentActivitiesAggregatesQueryRequest.builder().withBody(body).build();
    }

    public DevelopmentActivityAggregateResponse postUsersDevelopmentActivitiesAggregatesQuery(PostUsersDevelopmentActivitiesAggregatesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DevelopmentActivityAggregateResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DevelopmentActivityAggregateResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DevelopmentActivityAggregateResponse> postUsersDevelopmentActivitiesAggregatesQuery(ApiRequest<DevelopmentActivityAggregateParam> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DevelopmentActivityAggregateResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

