/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ContentAttachment;
import com.mypurecloud.sdk.v2.model.ContentGeneric;
import com.mypurecloud.sdk.v2.model.ContentList;
import com.mypurecloud.sdk.v2.model.ContentLocation;
import com.mypurecloud.sdk.v2.model.ContentNotificationTemplate;
import com.mypurecloud.sdk.v2.model.ContentQuickReply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message content element")
public class MessageContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private ContentLocation location = null;
    private ContentAttachment attachment = null;
    private ContentQuickReply quickReply = null;
    private ContentGeneric generic = null;
    private ContentList list = null;
    private ContentNotificationTemplate template = null;

    public MessageContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this content element. If contentType = \"Attachment\" only one item is allowed.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public MessageContent location(ContentLocation location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Location object")
    @JsonProperty(value="location")
    public ContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ContentLocation location) {
        this.location = location;
    }

    public MessageContent attachment(ContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment object")
    @JsonProperty(value="attachment")
    public ContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ContentAttachment attachment) {
        this.attachment = attachment;
    }

    public MessageContent quickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply object")
    @JsonProperty(value="quickReply")
    public ContentQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public MessageContent generic(ContentGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content object")
    @JsonProperty(value="generic")
    public ContentGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(ContentGeneric generic) {
        this.generic = generic;
    }

    public MessageContent list(ContentList list) {
        this.list = list;
        return this;
    }

    @ApiModelProperty(example="null", value="List content object")
    @JsonProperty(value="list")
    public ContentList getList() {
        return this.list;
    }

    public void setList(ContentList list) {
        this.list = list;
    }

    public MessageContent template(ContentNotificationTemplate template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification object")
    @JsonProperty(value="template")
    public ContentNotificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ContentNotificationTemplate template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContent messageContent = (MessageContent)o;
        return Objects.equals((Object)this.contentType, (Object)messageContent.contentType) && Objects.equals(this.location, messageContent.location) && Objects.equals(this.attachment, messageContent.attachment) && Objects.equals(this.quickReply, messageContent.quickReply) && Objects.equals(this.generic, messageContent.generic) && Objects.equals(this.list, messageContent.list) && Objects.equals(this.template, messageContent.template);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.location, this.attachment, this.quickReply, this.generic, this.list, this.template});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.list)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        LOCATION("Location"),
        QUICKREPLY("QuickReply"),
        NOTIFICATION("Notification"),
        GENERICTEMPLATE("GenericTemplate"),
        LISTTEMPLATE("ListTemplate");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

