/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.CallMediaParticipant;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CallConversation
implements Serializable {
    private String id = null;
    private String name = null;
    private List<CallMediaParticipant> participants = new ArrayList<CallMediaParticipant>();
    private List<String> otherMediaUris = new ArrayList<String>();
    private RecordingStateEnum recordingState = null;
    private Integer maxParticipants = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CallConversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallConversation participants(List<CallMediaParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants involved in the conversation.")
    @JsonProperty(value="participants")
    public List<CallMediaParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CallMediaParticipant> participants) {
        this.participants = participants;
    }

    public CallConversation otherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of other media channels involved in the conversation.")
    @JsonProperty(value="otherMediaUris")
    public List<String> getOtherMediaUris() {
        return this.otherMediaUris;
    }

    public void setOtherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
    }

    public CallConversation recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public CallConversation maxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    @ApiModelProperty(example="null", value="If this is a conference conversation, then this field indicates the maximum number of participants allowed to participant in the conference.")
    @JsonProperty(value="maxParticipants")
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallConversation callConversation = (CallConversation)o;
        return Objects.equals(this.id, callConversation.id) && Objects.equals(this.name, callConversation.name) && Objects.equals(this.participants, callConversation.participants) && Objects.equals(this.otherMediaUris, callConversation.otherMediaUris) && Objects.equals((Object)this.recordingState, (Object)callConversation.recordingState) && Objects.equals(this.maxParticipants, callConversation.maxParticipants) && Objects.equals(this.selfUri, callConversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.participants, this.otherMediaUris, this.recordingState, this.maxParticipants, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallConversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    otherMediaUris: ").append(this.toIndentedString(this.otherMediaUris)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    maxParticipants: ").append(this.toIndentedString(this.maxParticipants)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

