/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PutFlowsDatatableRowRequest {
    private String datatableId;
    private String rowId;
    private Object body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public PutFlowsDatatableRowRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public PutFlowsDatatableRowRequest withRowId(String rowId) {
        this.setRowId(rowId);
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public PutFlowsDatatableRowRequest withBody(Object body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutFlowsDatatableRowRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Object> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PutFlowsDatatableRowRequest.");
        }
        if (this.rowId == null) {
            throw new IllegalStateException("Missing the required parameter 'rowId' when building request for PutFlowsDatatableRowRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/flows/datatables/{datatableId}/rows/{rowId}").withPathParameter("datatableId", this.datatableId).withPathParameter("rowId", this.rowId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId, String rowId) {
        return new Builder().withRequiredParams(datatableId, rowId);
    }

    public static class Builder {
        private final PutFlowsDatatableRowRequest request = new PutFlowsDatatableRowRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withRowId(String rowId) {
            this.request.setRowId(rowId);
            return this;
        }

        public Builder withBody(Object body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String datatableId, String rowId) {
            this.request.setDatatableId(datatableId);
            this.request.setRowId(rowId);
            return this;
        }

        public PutFlowsDatatableRowRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PutFlowsDatatableRowRequest.");
            }
            if (this.request.rowId == null) {
                throw new IllegalStateException("Missing the required parameter 'rowId' when building request for PutFlowsDatatableRowRequest.");
            }
            return this.request;
        }
    }
}

