/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ChangePasswordRequest;
import java.util.HashMap;
import java.util.Map;

public class PostUserPasswordRequest {
    private String userId;
    private ChangePasswordRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PostUserPasswordRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public ChangePasswordRequest getBody() {
        return this.body;
    }

    public void setBody(ChangePasswordRequest body) {
        this.body = body;
    }

    public PostUserPasswordRequest withBody(ChangePasswordRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostUserPasswordRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ChangePasswordRequest> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostUserPasswordRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostUserPasswordRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/users/{userId}/password").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, ChangePasswordRequest body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PostUserPasswordRequest request = new PostUserPasswordRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(ChangePasswordRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, ChangePasswordRequest body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PostUserPasswordRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostUserPasswordRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostUserPasswordRequest.");
            }
            return this.request;
        }
    }
}

