/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesDownloadDownloadIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesRequest;
import com.mypurecloud.sdk.v2.api.request.PostTelephonySiptracesDownloadRequest;
import com.mypurecloud.sdk.v2.model.SIPSearchPublicRequest;
import com.mypurecloud.sdk.v2.model.SignedUrlResponse;
import com.mypurecloud.sdk.v2.model.SipDownloadResponse;
import com.mypurecloud.sdk.v2.model.SipSearchResult;
import java.io.IOException;
import java.util.Date;

public class TelephonyApi {
    private final ApiClient pcapiClient;

    public TelephonyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TelephonyApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public SipSearchResult getTelephonySiptraces(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) throws IOException, ApiException {
        return this.getTelephonySiptraces(this.createGetTelephonySiptracesRequest(dateStart, dateEnd, callId, toUser, fromUser, conversationId));
    }

    public ApiResponse<SipSearchResult> getTelephonySiptracesWithHttpInfo(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) throws IOException {
        return this.getTelephonySiptraces(this.createGetTelephonySiptracesRequest(dateStart, dateEnd, callId, toUser, fromUser, conversationId).withHttpInfo());
    }

    private GetTelephonySiptracesRequest createGetTelephonySiptracesRequest(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) {
        return GetTelephonySiptracesRequest.builder().withDateStart(dateStart).withDateEnd(dateEnd).withCallId(callId).withToUser(toUser).withFromUser(fromUser).withConversationId(conversationId).build();
    }

    public SipSearchResult getTelephonySiptraces(GetTelephonySiptracesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SipSearchResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SipSearchResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SipSearchResult> getTelephonySiptraces(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SipSearchResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SignedUrlResponse getTelephonySiptracesDownloadDownloadId(String downloadId) throws IOException, ApiException {
        return this.getTelephonySiptracesDownloadDownloadId(this.createGetTelephonySiptracesDownloadDownloadIdRequest(downloadId));
    }

    public ApiResponse<SignedUrlResponse> getTelephonySiptracesDownloadDownloadIdWithHttpInfo(String downloadId) throws IOException {
        return this.getTelephonySiptracesDownloadDownloadId(this.createGetTelephonySiptracesDownloadDownloadIdRequest(downloadId).withHttpInfo());
    }

    private GetTelephonySiptracesDownloadDownloadIdRequest createGetTelephonySiptracesDownloadDownloadIdRequest(String downloadId) {
        return GetTelephonySiptracesDownloadDownloadIdRequest.builder().withDownloadId(downloadId).build();
    }

    public SignedUrlResponse getTelephonySiptracesDownloadDownloadId(GetTelephonySiptracesDownloadDownloadIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SignedUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SignedUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SignedUrlResponse> getTelephonySiptracesDownloadDownloadId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SignedUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SipDownloadResponse postTelephonySiptracesDownload(SIPSearchPublicRequest sIPSearchPublicRequest) throws IOException, ApiException {
        return this.postTelephonySiptracesDownload(this.createPostTelephonySiptracesDownloadRequest(sIPSearchPublicRequest));
    }

    public ApiResponse<SipDownloadResponse> postTelephonySiptracesDownloadWithHttpInfo(SIPSearchPublicRequest sIPSearchPublicRequest) throws IOException {
        return this.postTelephonySiptracesDownload(this.createPostTelephonySiptracesDownloadRequest(sIPSearchPublicRequest).withHttpInfo());
    }

    private PostTelephonySiptracesDownloadRequest createPostTelephonySiptracesDownloadRequest(SIPSearchPublicRequest sIPSearchPublicRequest) {
        return PostTelephonySiptracesDownloadRequest.builder().withSIPSearchPublicRequest(sIPSearchPublicRequest).build();
    }

    public SipDownloadResponse postTelephonySiptracesDownload(PostTelephonySiptracesDownloadRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SipDownloadResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SipDownloadResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SipDownloadResponse> postTelephonySiptracesDownload(ApiRequest<SIPSearchPublicRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SipDownloadResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

